/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.teams.item.selector.web.internal;

import com.liferay.item.selector.ItemSelectorReturnType;
import com.liferay.item.selector.ItemSelectorViewDescriptor;
import com.liferay.item.selector.criteria.UUIDItemSelectorReturnType;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.service.TeamLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.TeamNameComparator;
import com.liferay.site.teams.item.selector.web.internal.SiteTeamsItemDescriptor;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;

public class SiteTeamsItemSelectorViewDescriptor
implements ItemSelectorViewDescriptor<Team> {
    private final HttpServletRequest _httpServletRequest;
    private String _keywords;
    private String _orderByCol;
    private String _orderByType;
    private final PortletURL _portletURL;
    private final ThemeDisplay _themeDisplay;

    public SiteTeamsItemSelectorViewDescriptor(HttpServletRequest httpServletRequest, PortletURL portletURL) {
        this._httpServletRequest = httpServletRequest;
        this._portletURL = portletURL;
        this._themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public String getDefaultDisplayStyle() {
        return "list";
    }

    public String[] getDisplayViews() {
        return new String[]{"list", "descriptive"};
    }

    public ItemSelectorViewDescriptor.ItemDescriptor getItemDescriptor(Team team) {
        return new SiteTeamsItemDescriptor(team);
    }

    public ItemSelectorReturnType getItemSelectorReturnType() {
        return new UUIDItemSelectorReturnType();
    }

    public String[] getOrderByKeys() {
        return new String[]{"name"};
    }

    public SearchContainer<Team> getSearchContainer() throws PortalException {
        return this._getTeamSearchContainer();
    }

    public boolean isShowBreadcrumb() {
        return false;
    }

    public boolean isShowSearch() {
        return true;
    }

    private String _getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords");
        return this._keywords;
    }

    private String _getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByCol", (String)"name");
        return this._orderByCol;
    }

    private String _getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    private SearchContainer<Team> _getTeamSearchContainer() {
        RenderRequest renderRequest = (RenderRequest)this._httpServletRequest.getAttribute("javax.portlet.request");
        SearchContainer teamSearchContainer = new SearchContainer((PortletRequest)renderRequest, this._portletURL, null, "no-teams-were-found");
        teamSearchContainer.setOrderByCol(this._getOrderByCol());
        boolean orderByAsc = false;
        if (Objects.equals(this._getOrderByType(), "asc")) {
            orderByAsc = true;
        }
        teamSearchContainer.setOrderByComparator((OrderByComparator)TeamNameComparator.getInstance((boolean)orderByAsc));
        teamSearchContainer.setOrderByType(this._getOrderByType());
        teamSearchContainer.setResultsAndTotal(() -> TeamLocalServiceUtil.search((long)this._themeDisplay.getScopeGroupId(), (String)this._getKeywords(), (String)this._getKeywords(), new LinkedHashMap(), (int)teamSearchContainer.getStart(), (int)teamSearchContainer.getEnd(), (OrderByComparator)teamSearchContainer.getOrderByComparator()), TeamLocalServiceUtil.searchCount((long)this._themeDisplay.getScopeGroupId(), (String)this._getKeywords(), (String)this._getKeywords(), new LinkedHashMap()));
        return teamSearchContainer;
    }
}

