/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.navigation.menu.web.internal.display.context;

import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.ItemSelectorReturnType;
import com.liferay.item.selector.criteria.UUIDItemSelectorReturnType;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactoryUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.display.template.PortletDisplayTemplate;
import com.liferay.site.navigation.item.selector.criterion.SiteNavigationMenuItemItemSelectorCriterion;
import com.liferay.site.navigation.item.selector.criterion.SiteNavigationMenuItemSelectorCriterion;
import com.liferay.site.navigation.menu.web.internal.configuration.SiteNavigationMenuPortletInstanceConfiguration;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.site.navigation.service.SiteNavigationMenuLocalServiceUtil;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class SiteNavigationMenuDisplayContext {
    private String _ddmTemplateKey;
    private int _displayDepth = -1;
    private String _displayStyle;
    private long _displayStyleGroupId;
    private String _expandedLevels;
    private final HttpServletRequest _httpServletRequest;
    private Integer _navigationMenuType;
    private Boolean _preview;
    private String _rootMenuItemId;
    private Integer _rootMenuItemLevel;
    private String _rootMenuItemType;
    private SiteNavigationMenu _siteNavigationMenu;
    private Long _siteNavigationMenuId;
    private final SiteNavigationMenuPortletInstanceConfiguration _siteNavigationMenuPortletInstanceConfiguration;

    public SiteNavigationMenuDisplayContext(HttpServletRequest httpServletRequest) throws ConfigurationException {
        this._httpServletRequest = httpServletRequest;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        this._siteNavigationMenuPortletInstanceConfiguration = (SiteNavigationMenuPortletInstanceConfiguration)portletDisplay.getPortletInstanceConfiguration(SiteNavigationMenuPortletInstanceConfiguration.class);
    }

    public String getDDMTemplateKey() {
        if (this._ddmTemplateKey != null) {
            return this._ddmTemplateKey;
        }
        String displayStyle = this.getDisplayStyle();
        if (displayStyle != null) {
            PortletDisplayTemplate portletDisplayTemplate = (PortletDisplayTemplate)this._httpServletRequest.getAttribute("PORTLET_DISPLAY_TEMPLATE");
            this._ddmTemplateKey = portletDisplayTemplate.getDDMTemplateKey(displayStyle);
        }
        return this._ddmTemplateKey;
    }

    public int getDisplayDepth() {
        if (this._displayDepth != -1) {
            return this._displayDepth;
        }
        this._displayDepth = ParamUtil.getInteger((HttpServletRequest)this._httpServletRequest, (String)"displayDepth", (int)this._siteNavigationMenuPortletInstanceConfiguration.displayDepth());
        return this._displayDepth;
    }

    public String getDisplayStyle() {
        if (this._displayStyle != null) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle", (String)this._siteNavigationMenuPortletInstanceConfiguration.displayStyle());
        return this._displayStyle;
    }

    public long getDisplayStyleGroupId() {
        if (this._displayStyleGroupId != 0L) {
            return this._displayStyleGroupId;
        }
        this._displayStyleGroupId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"displayStyleGroupId", (long)this._siteNavigationMenuPortletInstanceConfiguration.displayStyleGroupId());
        if (this._displayStyleGroupId <= 0L) {
            ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this._displayStyleGroupId = themeDisplay.getSiteGroupId();
        }
        return this._displayStyleGroupId;
    }

    public String getExpandedLevels() {
        if (this._expandedLevels != null) {
            return this._expandedLevels;
        }
        String defaultExpandedLevels = this._siteNavigationMenuPortletInstanceConfiguration.expandedLevels();
        this._expandedLevels = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"expandedLevels", (String)defaultExpandedLevels);
        return this._expandedLevels;
    }

    public String getRootMenuItemEventName() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        return portletDisplay.getNamespace() + "selectRootMenuItem";
    }

    public String getRootMenuItemId() {
        if (this._rootMenuItemId != null) {
            return this._rootMenuItemId;
        }
        String defaultRootMenuItemId = this._siteNavigationMenuPortletInstanceConfiguration.rootLayoutUuid();
        if (Validator.isNull((String)defaultRootMenuItemId)) {
            defaultRootMenuItemId = this._siteNavigationMenuPortletInstanceConfiguration.rootMenuItemId();
        }
        this._rootMenuItemId = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"rootMenuItemId", (String)defaultRootMenuItemId);
        return this._rootMenuItemId;
    }

    public int getRootMenuItemLevel() {
        if (this._rootMenuItemLevel != null) {
            return this._rootMenuItemLevel;
        }
        int defaultRootMenuItemLevel = this._siteNavigationMenuPortletInstanceConfiguration.rootMenuItemLevel();
        this._rootMenuItemLevel = ParamUtil.getInteger((HttpServletRequest)this._httpServletRequest, (String)"rootMenuItemLevel", (int)defaultRootMenuItemLevel);
        return this._rootMenuItemLevel;
    }

    public String getRootMenuItemSelectorURL() {
        String eventName = this.getRootMenuItemEventName();
        ItemSelector itemSelector = (ItemSelector)this._httpServletRequest.getAttribute("ITEM_SELECTOR");
        SiteNavigationMenuItemItemSelectorCriterion itemSelectorCriterion = new SiteNavigationMenuItemItemSelectorCriterion();
        itemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new UUIDItemSelectorReturnType()});
        PortletURL itemSelectorURL = itemSelector.getItemSelectorURL(RequestBackedPortletURLFactoryUtil.create((HttpServletRequest)this._httpServletRequest), eventName, new ItemSelectorCriterion[]{itemSelectorCriterion});
        return itemSelectorURL.toString();
    }

    public String getRootMenuItemType() {
        if (this._rootMenuItemType != null) {
            return this._rootMenuItemType;
        }
        String defaultRootMenuItemType = this._siteNavigationMenuPortletInstanceConfiguration.rootMenuItemType();
        this._rootMenuItemType = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"rootMenuItemType", (String)defaultRootMenuItemType);
        return this._rootMenuItemType;
    }

    public long getSelectSiteNavigationMenuId() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        int siteNavigationMenuType = this.getSiteNavigationMenuType();
        long siteNavigationMenuId = this.getSiteNavigationMenuId();
        if (siteNavigationMenuType == -1 && siteNavigationMenuId <= 0L) {
            SiteNavigationMenu siteNavigationMenu = SiteNavigationMenuLocalServiceUtil.fetchSiteNavigationMenu((long)themeDisplay.getScopeGroupId(), (int)this._getDefaultSelectSiteNavigationMenuType());
            if (siteNavigationMenu != null) {
                return siteNavigationMenu.getSiteNavigationMenuId();
            }
            return 0L;
        }
        if (siteNavigationMenuType > 0) {
            SiteNavigationMenu siteNavigationMenu = SiteNavigationMenuLocalServiceUtil.fetchSiteNavigationMenu((long)themeDisplay.getScopeGroupId(), (int)siteNavigationMenuType);
            if (siteNavigationMenu != null) {
                return siteNavigationMenu.getSiteNavigationMenuId();
            }
            return 0L;
        }
        return siteNavigationMenuId;
    }

    public int getSelectSiteNavigationMenuType() {
        int selectSiteNavigationMenuType = this.getSiteNavigationMenuType();
        if (selectSiteNavigationMenuType > 0) {
            return selectSiteNavigationMenuType;
        }
        return this._getDefaultSelectSiteNavigationMenuType();
    }

    public SiteNavigationMenu getSiteNavigationMenu() {
        if (this._siteNavigationMenu != null) {
            return this._siteNavigationMenu;
        }
        this._siteNavigationMenu = SiteNavigationMenuLocalServiceUtil.fetchSiteNavigationMenu((long)this.getSiteNavigationMenuId());
        return this._siteNavigationMenu;
    }

    public String getSiteNavigationMenuEventName() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        return portletDisplay.getNamespace() + "selectSiteNavigationMenu";
    }

    public long getSiteNavigationMenuId() {
        if (this._siteNavigationMenuId != null) {
            return this._siteNavigationMenuId;
        }
        this._siteNavigationMenuId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"siteNavigationMenuId", (long)this._siteNavigationMenuPortletInstanceConfiguration.siteNavigationMenuId());
        return this._siteNavigationMenuId;
    }

    public String getSiteNavigationMenuItemSelectorURL() {
        String eventName = this.getSiteNavigationMenuEventName();
        ItemSelector itemSelector = (ItemSelector)this._httpServletRequest.getAttribute("ITEM_SELECTOR");
        SiteNavigationMenuItemSelectorCriterion itemSelectorCriterion = new SiteNavigationMenuItemSelectorCriterion();
        itemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new UUIDItemSelectorReturnType()});
        PortletURL itemSelectorURL = itemSelector.getItemSelectorURL(RequestBackedPortletURLFactoryUtil.create((HttpServletRequest)this._httpServletRequest), eventName, new ItemSelectorCriterion[]{itemSelectorCriterion});
        return itemSelectorURL.toString();
    }

    public int getSiteNavigationMenuType() {
        if (this._navigationMenuType != null) {
            return this._navigationMenuType;
        }
        int siteNavigationMenuType = this._siteNavigationMenuPortletInstanceConfiguration.siteNavigationMenuType();
        this._navigationMenuType = ParamUtil.getInteger((HttpServletRequest)this._httpServletRequest, (String)"siteNavigationMenuType", (int)siteNavigationMenuType);
        return this._navigationMenuType;
    }

    public String getSiteNavigationMenuTypeLabel() {
        int type = this.getSiteNavigationMenuType();
        String typeKey = "select";
        if (type == 1) {
            typeKey = "primary-navigation";
        } else if (type == 5) {
            typeKey = "private-pages-hierarchy";
        } else if (type == 6) {
            typeKey = "public-pages-hierarchy";
        } else if (type == 2) {
            typeKey = "secondary-navigation";
        } else if (type == 3) {
            typeKey = "social-navigation";
        }
        return LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)typeKey);
    }

    public boolean isPreview() {
        if (this._preview != null) {
            return this._preview;
        }
        this._preview = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"preview", (boolean)this._siteNavigationMenuPortletInstanceConfiguration.preview());
        return this._preview;
    }

    public boolean isSiteNavigationMenuSelected() {
        return this._siteNavigationMenuPortletInstanceConfiguration.siteNavigationMenuId() > 0L && this._siteNavigationMenuPortletInstanceConfiguration.siteNavigationMenuType() == -1;
    }

    private int _getDefaultSelectSiteNavigationMenuType() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        if (layout.isPrivateLayout()) {
            return 5;
        }
        return 6;
    }
}

