/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.navigation.menu.web.internal.exportimport.portlet.preferences.processor;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.site.navigation.service.SiteNavigationMenuLocalService;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_site_navigation_menu_web_portlet_SiteNavigationMenuPortlet"}, service={ExportImportPortletPreferencesProcessor.class})
public class SiteNavigationMenuExportImportPortletPreferencesProcessor
implements ExportImportPortletPreferencesProcessor {
    @Reference(target="(name=PortletDisplayTemplateExporter)")
    private Capability _exportCapability;
    @Reference(target="(name=PortletDisplayTemplateImporter)")
    private Capability _importCapability;
    @Reference(unbind="-")
    private SiteNavigationMenuLocalService _siteNavigationMenuLocalService;

    public List<Capability> getExportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._exportCapability});
    }

    public List<Capability> getImportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._importCapability});
    }

    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        long scopeGroupId;
        String siteNavigationMenuUuid;
        SiteNavigationMenu siteNavigationMenuToExport;
        SiteNavigationMenu siteNavigationMenu;
        try {
            portletDataContext.addPortletPermissions("com.liferay.site.navigation");
        }
        catch (PortalException pe) {
            throw new PortletDataException("Unable to export portlet permissions", (Throwable)pe);
        }
        long siteNavigationMenuId = GetterUtil.getLong((String)portletPreferences.getValue("siteNavigationMenuId", null));
        if (siteNavigationMenuId > 0L && (siteNavigationMenu = this._siteNavigationMenuLocalService.fetchSiteNavigationMenu(siteNavigationMenuId)) != null && (siteNavigationMenuToExport = this._siteNavigationMenuLocalService.fetchSiteNavigationMenuByUuidAndGroupId(siteNavigationMenuUuid = siteNavigationMenu.getUuid(), scopeGroupId = portletDataContext.getScopeGroupId())) != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletDataContext.getPortletId(), (StagedModel)siteNavigationMenuToExport);
        }
        return portletPreferences;
    }

    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            portletDataContext.importPortletPermissions("com.liferay.site.navigation");
        }
        catch (PortalException pe) {
            throw new PortletDataException("Unable to import portlet permissions", (Throwable)pe);
        }
        long importedSiteNavigationMenuId = GetterUtil.getLong((String)portletPreferences.getValue("siteNavigationMenuId", null));
        try {
            if (importedSiteNavigationMenuId > 0L) {
                StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, SiteNavigationMenu.class, (long)importedSiteNavigationMenuId);
                Map siteNavigationMenuIds = portletDataContext.getNewPrimaryKeysMap(SiteNavigationMenu.class);
                long siteNavigationMenuId = MapUtil.getLong((Map)siteNavigationMenuIds, (long)importedSiteNavigationMenuId, (long)importedSiteNavigationMenuId);
                if (siteNavigationMenuId > 0L) {
                    portletPreferences.setValue("siteNavigationMenuId", String.valueOf(siteNavigationMenuId));
                }
            }
        }
        catch (ReadOnlyException roe) {
            PortletDataException pde = new PortletDataException((Throwable)roe);
            throw pde;
        }
        return portletPreferences;
    }
}

