/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.navigation.menu.item.layout.internal.type;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.staging.LayoutStaging;
import com.liferay.frontend.taglib.servlet.taglib.util.JSPRenderer;
import com.liferay.item.selector.ItemSelector;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import com.liferay.site.navigation.type.SiteNavigationMenuItemType;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"site.navigation.menu.item.type=layout"}, service={SiteNavigationMenuItemType.class})
public class LayoutSiteNavigationMenuItemType
implements SiteNavigationMenuItemType {
    @Reference
    private ItemSelector _itemSelector;
    @Reference
    private JSPRenderer _jspRenderer;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutStaging _layoutStaging;
    @Reference
    private Portal _portal;
    @Reference(target="(osgi.web.symbolicname=com.liferay.site.navigation.menu.item.layout)", unbind="-")
    private ServletContext _servletContext;

    public boolean exportData(PortletDataContext portletDataContext, Element siteNavigationMenuItemElement, SiteNavigationMenuItem siteNavigationMenuItem) throws PortalException {
        Layout layout = this._getLayout(siteNavigationMenuItem);
        LayoutRevision layoutRevision = this._layoutStaging.getLayoutRevision(layout);
        if (layoutRevision != null && (layoutRevision.getStatus() == 2 || layoutRevision.isIncomplete())) {
            return false;
        }
        portletDataContext.addReferenceElement((ClassedModel)siteNavigationMenuItem, siteNavigationMenuItemElement, (ClassedModel)layout, "dependency", true);
        return true;
    }

    public PortletURL getAddURL(RenderRequest renderRequest, RenderResponse renderResponse) {
        PortletURL addURL = renderResponse.createActionURL();
        addURL.setParameter("javax.portlet.action", "/navigation_menu/add_layout_site_navigation_menu_item");
        return addURL;
    }

    public String getIcon() {
        return "page";
    }

    public String getLabel(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)"page");
    }

    public Layout getLayout(SiteNavigationMenuItem siteNavigationMenuItem) {
        return this._fetchLayout(siteNavigationMenuItem);
    }

    public String getRegularURL(HttpServletRequest httpServletRequest, SiteNavigationMenuItem siteNavigationMenuItem) throws Exception {
        Layout layout = this._fetchLayout(siteNavigationMenuItem);
        return layout.getRegularURL(httpServletRequest);
    }

    public String getResetLayoutURL(HttpServletRequest httpServletRequest, SiteNavigationMenuItem siteNavigationMenuItem) throws Exception {
        Layout layout = this._fetchLayout(siteNavigationMenuItem);
        return layout.getResetLayoutURL(httpServletRequest);
    }

    public String getResetMaxStateURL(HttpServletRequest httpServletRequest, SiteNavigationMenuItem siteNavigationMenuItem) throws Exception {
        Layout layout = this._fetchLayout(siteNavigationMenuItem);
        return layout.getResetMaxStateURL(httpServletRequest);
    }

    public String getSubtitle(SiteNavigationMenuItem siteNavigationMenuItem, Locale locale) {
        Layout layout = this._fetchLayout(siteNavigationMenuItem);
        if (layout.isPublicLayout()) {
            return LanguageUtil.get((Locale)locale, (String)"public-page");
        }
        return LanguageUtil.get((Locale)locale, (String)"private-page");
    }

    public String getTarget(SiteNavigationMenuItem siteNavigationMenuItem) {
        Layout layout = this._fetchLayout(siteNavigationMenuItem);
        return layout.getTarget();
    }

    public String getTitle(SiteNavigationMenuItem siteNavigationMenuItem, Locale locale) {
        Layout layout = this._fetchLayout(siteNavigationMenuItem);
        if (!this._isUseCustomName(siteNavigationMenuItem)) {
            return layout.getName(locale);
        }
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.fastLoad(siteNavigationMenuItem.getTypeSettings());
        String defaultLanguageId = typeSettingsProperties.getProperty("defaultLanguageId", LocaleUtil.toLanguageId((Locale)LocaleUtil.getMostRelevantLocale()));
        String defaultTitle = typeSettingsProperties.getProperty("name_" + defaultLanguageId);
        if (layout != null) {
            defaultTitle = layout.getName(locale);
        }
        return typeSettingsProperties.getProperty("name_" + LocaleUtil.toLanguageId((Locale)locale), defaultTitle);
    }

    public String getType() {
        return "layout";
    }

    public String getTypeSettingsFromLayout(Layout layout) {
        UnicodeProperties unicodeProperties = new UnicodeProperties();
        unicodeProperties.setProperty("groupId", String.valueOf(layout.getGroupId()));
        unicodeProperties.setProperty("layoutUuid", layout.getUuid());
        unicodeProperties.setProperty("privateLayout", String.valueOf(layout.isPrivateLayout()));
        return unicodeProperties.toString();
    }

    public String getUnescapedName(SiteNavigationMenuItem siteNavigationMenuItem, String languageId) {
        String title = this.getTitle(siteNavigationMenuItem, LocaleUtil.fromLanguageId((String)languageId));
        if (Validator.isNotNull((String)title)) {
            return title;
        }
        Layout layout = this._fetchLayout(siteNavigationMenuItem);
        return layout.getName(languageId);
    }

    public boolean hasPermission(PermissionChecker permissionChecker, SiteNavigationMenuItem siteNavigationMenuItem) throws PortalException {
        Layout layout = this._fetchLayout(siteNavigationMenuItem);
        return LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)layout.getPlid(), (String)"VIEW");
    }

    public String iconURL(SiteNavigationMenuItem siteNavigationMenuItem, String pathImage) {
        Layout layout = this._fetchLayout(siteNavigationMenuItem);
        if (layout == null || !layout.isIconImage()) {
            return "";
        }
        StringBundler sb = new StringBundler(5);
        sb.append(pathImage);
        sb.append("/layout_icon?img_id=");
        sb.append(layout.getIconImageId());
        sb.append("&t=");
        sb.append(WebServerServletTokenUtil.getToken((long)layout.getIconImageId()));
        return sb.toString();
    }

    public boolean importData(PortletDataContext portletDataContext, SiteNavigationMenuItem siteNavigationMenuItem, SiteNavigationMenuItem importedSiteNavigationMenuItem) throws PortalException {
        Layout layout = this._getLayout(importedSiteNavigationMenuItem);
        if (layout == null) {
            if (ExportImportThreadLocal.isPortletImportInProcess()) {
                throw new NoSuchLayoutException();
            }
            return false;
        }
        LayoutRevision layoutRevision = this._layoutStaging.getLayoutRevision(layout);
        if (layoutRevision != null && layoutRevision.getStatus() == 2) {
            return false;
        }
        Map layoutPlids = portletDataContext.getNewPrimaryKeysMap(Layout.class);
        long plid = MapUtil.getLong((Map)layoutPlids, (long)layout.getPlid(), (long)layout.getPlid());
        Layout importedLayout = this._layoutLocalService.fetchLayout(plid);
        if (importedLayout != null) {
            UnicodeProperties typeSettingsProperties = new UnicodeProperties();
            typeSettingsProperties.fastLoad(siteNavigationMenuItem.getTypeSettings());
            typeSettingsProperties.put("layoutUuid", importedLayout.getUuid());
            typeSettingsProperties.put("groupId", String.valueOf(importedLayout.getGroupId()));
            typeSettingsProperties.put("privateLayout", String.valueOf(importedLayout.isPrivateLayout()));
            importedSiteNavigationMenuItem.setTypeSettings(typeSettingsProperties.toString());
        }
        return true;
    }

    public boolean isBrowsable(SiteNavigationMenuItem siteNavigationMenuItem) {
        Layout layout = this._fetchLayout(siteNavigationMenuItem);
        LayoutType layoutType = layout.getLayoutType();
        return layoutType.isBrowsable();
    }

    public boolean isChildSelected(boolean selectable, SiteNavigationMenuItem siteNavigationMenuItem, Layout curLayout) throws PortalException {
        Layout layout = this._fetchLayout(siteNavigationMenuItem);
        return layout.isChildSelected(selectable, curLayout);
    }

    public boolean isSelected(boolean selectable, SiteNavigationMenuItem siteNavigationMenuItem, Layout curLayout) throws Exception {
        Layout layout = this._fetchLayout(siteNavigationMenuItem);
        return layout.isSelected(selectable, curLayout, curLayout.getAncestorPlid());
    }

    public void renderAddPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletRequest.setAttribute("ITEM_SELECTOR", (Object)this._itemSelector);
        this._jspRenderer.renderJSP(this._servletContext, httpServletRequest, httpServletResponse, "/add_layout.jsp");
    }

    public void renderEditPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SiteNavigationMenuItem siteNavigationMenuItem) throws IOException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        httpServletRequest.setAttribute("ITEM_SELECTOR", (Object)this._itemSelector);
        httpServletRequest.setAttribute("SEL_LAYOUT", (Object)this._fetchLayout(siteNavigationMenuItem));
        httpServletRequest.setAttribute("TITLE", (Object)this.getTitle(siteNavigationMenuItem, themeDisplay.getLocale()));
        httpServletRequest.setAttribute("SITE_NAVIGATION_MENU_ITEM", (Object)siteNavigationMenuItem);
        httpServletRequest.setAttribute("SET_CUSTOM_NAME", (Object)this._isUseCustomName(siteNavigationMenuItem));
        this._jspRenderer.renderJSP(this._servletContext, httpServletRequest, httpServletResponse, "/edit_layout.jsp");
    }

    private Layout _fetchLayout(SiteNavigationMenuItem siteNavigationMenuItem) {
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.fastLoad(siteNavigationMenuItem.getTypeSettings());
        String layoutUuid = (String)typeSettingsProperties.get((Object)"layoutUuid");
        boolean privateLayout = GetterUtil.getBoolean((String)((String)typeSettingsProperties.get((Object)"privateLayout")));
        return this._layoutLocalService.fetchLayoutByUuidAndGroupId(layoutUuid, siteNavigationMenuItem.getGroupId(), privateLayout);
    }

    private Layout _getLayout(SiteNavigationMenuItem siteNavigationMenuItem) {
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.fastLoad(siteNavigationMenuItem.getTypeSettings());
        String layoutUuid = (String)typeSettingsProperties.get((Object)"layoutUuid");
        boolean privateLayout = GetterUtil.getBoolean((String)((String)typeSettingsProperties.get((Object)"privateLayout")));
        Layout layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(layoutUuid, siteNavigationMenuItem.getGroupId(), privateLayout);
        if (layout == null && ExportImportThreadLocal.isImportInProcess()) {
            layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(layoutUuid, siteNavigationMenuItem.getGroupId(), !privateLayout);
        }
        return layout;
    }

    private boolean _isUseCustomName(SiteNavigationMenuItem siteNavigationMenuItem) {
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.fastLoad(siteNavigationMenuItem.getTypeSettings());
        return GetterUtil.getBoolean((String)((String)typeSettingsProperties.get((Object)"setCustomName")));
    }
}

