/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.navigation.menu.item.layout.internal.portlet.action;

import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.site.navigation.exception.SiteNavigationMenuItemNameException;
import com.liferay.site.navigation.menu.item.util.SiteNavigationMenuItemUtil;
import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import com.liferay.site.navigation.service.SiteNavigationMenuItemService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_site_navigation_admin_web_portlet_SiteNavigationAdminPortlet", "mvc.command.name=/navigation_menu/add_layout_site_navigation_menu_item"}, service={MVCActionCommand.class})
public class AddLayoutSiteNavigationMenuItemMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SiteNavigationMenuItemService _siteNavigationMenuItemService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long siteNavigationMenuId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"siteNavigationMenuId");
        String type = ParamUtil.getString((PortletRequest)actionRequest, (String)"type");
        UnicodeProperties typeSettingsProperties = SiteNavigationMenuItemUtil.getSiteNavigationMenuItemProperties((PortletRequest)actionRequest, (String)"TypeSettingsProperties--");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        List layoutUUIDs = StringUtil.split((String)typeSettingsProperties.getProperty("layoutUuid"));
        HashMap<Long, SiteNavigationMenuItem> layoutSiteNavigationMenuItemMap = new HashMap<Long, SiteNavigationMenuItem>();
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            for (String string : layoutUUIDs) {
                boolean privateLayout;
                long groupId;
                Layout layout = this._layoutLocalService.fetchLayoutByUuidAndGroupId(string, groupId = GetterUtil.getLong((String)((String)typeSettingsProperties.get((Object)"groupId"))), privateLayout = GetterUtil.getBoolean((String)((String)typeSettingsProperties.get((Object)"privateLayout"))));
                if (layout == null) continue;
                UnicodeProperties curTypeSettingsProperties = new UnicodeProperties(true);
                curTypeSettingsProperties.setProperty("groupId", String.valueOf(groupId));
                curTypeSettingsProperties.setProperty("layoutUuid", string);
                curTypeSettingsProperties.setProperty("privateLayout", String.valueOf(privateLayout));
                curTypeSettingsProperties.setProperty("title", layout.getName(themeDisplay.getLocale()));
                SiteNavigationMenuItem siteNavigationMenuItem = this._siteNavigationMenuItemService.addSiteNavigationMenuItem(themeDisplay.getScopeGroupId(), siteNavigationMenuId, 0L, type, curTypeSettingsProperties.toString(), serviceContext);
                layoutSiteNavigationMenuItemMap.put(layout.getPlid(), siteNavigationMenuItem);
            }
            for (Map.Entry entry : layoutSiteNavigationMenuItemMap.entrySet()) {
                SiteNavigationMenuItem parentSiteNavigationMenuItem;
                Layout layout = this._layoutLocalService.fetchLayout(((Long)entry.getKey()).longValue());
                if (layout.getParentPlid() <= 0L || (parentSiteNavigationMenuItem = (SiteNavigationMenuItem)layoutSiteNavigationMenuItemMap.get(layout.getParentPlid())) == null) continue;
                SiteNavigationMenuItem siteNavigationMenuItem = (SiteNavigationMenuItem)entry.getValue();
                this._siteNavigationMenuItemService.updateSiteNavigationMenuItem(siteNavigationMenuItem.getSiteNavigationMenuItemId(), parentSiteNavigationMenuItem.getSiteNavigationMenuItemId(), layout.getPriority());
            }
            jsonObject.put("siteNavigationMenuItemId", layoutSiteNavigationMenuItemMap);
        }
        catch (SiteNavigationMenuItemNameException snmine) {
            HttpServletRequest httpServletRequest = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
            jsonObject.put("errorMessage", LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"an-unexpected-error-occurred"));
        }
        JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
    }
}

