/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.navigation.menu.item.layout.internal.model.listener;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import com.liferay.site.navigation.service.SiteNavigationMenuItemLocalService;
import com.liferay.site.navigation.service.SiteNavigationMenuLocalService;
import com.liferay.site.navigation.type.SiteNavigationMenuItemType;
import com.liferay.site.navigation.type.SiteNavigationMenuItemTypeRegistry;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class LayoutModelListener
extends BaseModelListener<Layout> {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private SiteNavigationMenuItemLocalService _siteNavigationMenuItemLocalService;
    @Reference
    private SiteNavigationMenuItemTypeRegistry _siteNavigationMenuItemTypeRegistry;
    @Reference
    private SiteNavigationMenuLocalService _siteNavigationMenuLocalService;

    public void onAfterCreate(Layout layout) throws ModelListenerException {
        if (ExportImportThreadLocal.isStagingInProcess()) {
            return;
        }
        if (!this._isVisible(layout)) {
            return;
        }
        long[] siteNavigationMenuIds = GetterUtil.getLongValues((String[])StringUtil.split((String)layout.getTypeSettingsProperty("siteNavigationMenuId"), (char)','));
        this._addLayoutSiteNavigationMenuItems(siteNavigationMenuIds, layout);
    }

    public void onAfterRemove(Layout layout) throws ModelListenerException {
        if (layout == null) {
            return;
        }
        List siteNavigationMenus = this._siteNavigationMenuLocalService.getSiteNavigationMenus(layout.getGroupId());
        try {
            for (SiteNavigationMenu siteNavigationMenu : siteNavigationMenus) {
                this._deleteSiteNavigationMenuItem(siteNavigationMenu, layout);
            }
        }
        catch (PortalException pe) {
            throw new ModelListenerException((Throwable)pe);
        }
    }

    public void onAfterUpdate(Layout layout) throws ModelListenerException {
        if (!this._isVisible(layout)) {
            return;
        }
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        boolean published = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("published"));
        if (!published) {
            long[] siteNavigationMenuIds = GetterUtil.getLongValues((String[])StringUtil.split((String)layout.getTypeSettingsProperty("siteNavigationMenuId"), (char)','));
            this._addLayoutSiteNavigationMenuItems(siteNavigationMenuIds, layout);
        }
    }

    private void _addLayoutSiteNavigationMenuItems(long[] siteNavigationMenuIds, Layout layout) {
        for (long siteNavigationMenuId : siteNavigationMenuIds) {
            if (siteNavigationMenuId <= 0L) continue;
            this._addSiteNavigationMenuItem(siteNavigationMenuId, layout);
        }
    }

    private void _addSiteNavigationMenuItem(long siteNavigationMenuId, Layout layout) {
        if (ExportImportThreadLocal.isImportInProcess() || ExportImportThreadLocal.isStagingInProcess() || this._menuItemExists(siteNavigationMenuId, layout)) {
            return;
        }
        SiteNavigationMenuItemType siteNavigationMenuItemType = this._siteNavigationMenuItemTypeRegistry.getSiteNavigationMenuItemType("layout");
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        try {
            long parentSiteNavigationMenuItemId = this._getParentSiteNavigationMenuItemId(layout.getParentPlid(), siteNavigationMenuId);
            this._siteNavigationMenuItemLocalService.addSiteNavigationMenuItem(layout.getUserId(), layout.getGroupId(), siteNavigationMenuId, parentSiteNavigationMenuItemId, "layout", siteNavigationMenuItemType.getTypeSettingsFromLayout(layout), serviceContext);
        }
        catch (PortalException pe) {
            throw new ModelListenerException((Throwable)pe);
        }
    }

    private void _deleteSiteNavigationMenuItem(SiteNavigationMenu siteNavigationMenu, Layout layout) throws PortalException {
        List siteNavigationMenuItems = this._siteNavigationMenuItemLocalService.getSiteNavigationMenuItems(siteNavigationMenu.getSiteNavigationMenuId());
        for (SiteNavigationMenuItem siteNavigationMenuItem : siteNavigationMenuItems) {
            UnicodeProperties unicodeProperties = new UnicodeProperties();
            unicodeProperties.fastLoad(siteNavigationMenuItem.getTypeSettings());
            String layoutUuid = unicodeProperties.getProperty("layoutUuid");
            if (!Objects.equals(layout.getUuid(), layoutUuid)) continue;
            this._siteNavigationMenuItemLocalService.deleteSiteNavigationMenuItem(siteNavigationMenuItem.getSiteNavigationMenuItemId());
        }
    }

    private long _getParentSiteNavigationMenuItemId(long parentPlid, long siteNavigationMenuItemId) {
        if (parentPlid == 0L) {
            return 0L;
        }
        Layout parentLayout = this._layoutLocalService.fetchLayout(parentPlid);
        List siteNavigationMenuItems = this._siteNavigationMenuItemLocalService.getSiteNavigationMenuItems(siteNavigationMenuItemId);
        for (SiteNavigationMenuItem siteNavigationMenuItem : siteNavigationMenuItems) {
            UnicodeProperties unicodeProperties = new UnicodeProperties();
            unicodeProperties.fastLoad(siteNavigationMenuItem.getTypeSettings());
            String layoutUuid = unicodeProperties.getProperty("layoutUuid");
            if (!Objects.equals(parentLayout.getUuid(), layoutUuid)) continue;
            return siteNavigationMenuItem.getSiteNavigationMenuItemId();
        }
        return 0L;
    }

    private boolean _isVisible(Layout layout) {
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        boolean visible = GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("visible"), (boolean)true);
        return !layout.isHidden() && visible && (!Objects.equals(layout.getType(), "content") || !Objects.equals(layout.getCreateDate(), layout.getPublishDate()));
    }

    private boolean _menuItemExists(long siteNavigationMenuId, Layout layout) {
        List siteNavigationMenuItems = this._siteNavigationMenuItemLocalService.getSiteNavigationMenuItems(siteNavigationMenuId);
        for (SiteNavigationMenuItem siteNavigationMenuItem : siteNavigationMenuItems) {
            UnicodeProperties unicodeProperties = new UnicodeProperties();
            unicodeProperties.fastLoad(siteNavigationMenuItem.getTypeSettings());
            String layoutUuid = unicodeProperties.getProperty("layoutUuid");
            if (!Objects.equals(layout.getUuid(), layoutUuid)) continue;
            return true;
        }
        return false;
    }
}

