/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.navigation.breadcrumb.web.internal.upgrade.v1_0_0;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.upgrade.BaseUpgradePortletPreferences;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;

public class UpgradePortletPreferences
extends BaseUpgradePortletPreferences {
    private static final Log _log = LogFactoryUtil.getLog(UpgradePortletPreferences.class);

    protected String[] getPortletIds() {
        return new String[]{StringUtil.quote((String)"com_liferay_site_navigation_breadcrumb_web_portlet_SiteNavigationBreadcrumbPortlet", (char)'%')};
    }

    protected void upgradeDisplayStyle(PortletPreferences portletPreferences) throws ReadOnlyException {
        String displayStyle = GetterUtil.getString((String)portletPreferences.getValue("displayStyle", null));
        if (Validator.isNull((String)displayStyle) || displayStyle.startsWith("ddmTemplate_")) {
            return;
        }
        if (displayStyle.equals("horizontal") || displayStyle.equals("1")) {
            portletPreferences.setValue("displayStyle", "ddmTemplate_breadcrumb-horizontal-ftl");
        } else if (displayStyle.equals("vertical") || displayStyle.equals("2")) {
            portletPreferences.setValue("displayStyle", "ddmTemplate_breadcrumb-vertical-ftl");
        } else {
            portletPreferences.reset("displayStyle");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Display styles for breadcrumbs are deprecated in favor of application display templates");
            }
        }
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        this.upgradeDisplayStyle(portletPreferences);
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }
}

