Liferay.Loader.define("site-navigation-admin-web@3.0.24/js/ContextualSidebar", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/layout', '@frontend-taglib-clay$clayui/loading-indicator', 'frontend-js-react-web', 'frontend-js-web', 'frontend-js-metal-web$metal-dom', 'frontend-js-react-web$react', './SiteNavigationMenuEditor'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _loadingIndicator = _interopRequireDefault(require("@frontend-taglib-clay$clayui/loading-indicator"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _frontendJsWeb = require("frontend-js-web");

    var _metalDom = require("frontend-js-metal-web$metal-dom");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _SiteNavigationMenuEditor = _interopRequireDefault(require("./SiteNavigationMenuEditor"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function ContextualSidebar(_ref) {
      var editSiteNavigationMenuItemParentURL = _ref.editSiteNavigationMenuItemParentURL,
          editSiteNavigationMenuItemURL = _ref.editSiteNavigationMenuItemURL,
          editSiteNavigationMenuSettingsURL = _ref.editSiteNavigationMenuSettingsURL,
          portletId = _ref.portletId,
          redirect = _ref.redirect,
          siteNavigationMenuId = _ref.siteNavigationMenuId,
          siteNavigationMenuName = _ref.siteNavigationMenuName;

      var _useState = (0, _react.useState)(''),
          _useState2 = _slicedToArray(_useState, 2),
          body = _useState2[0],
          setBody = _useState2[1];

      var _useState3 = (0, _react.useState)(false),
          _useState4 = _slicedToArray(_useState3, 2),
          changed = _useState4[0],
          setChanged = _useState4[1];

      var _useState5 = (0, _react.useState)(false),
          _useState6 = _slicedToArray(_useState5, 2),
          loading = _useState6[0],
          setLoading = _useState6[1];

      var _useState7 = (0, _react.useState)(''),
          _useState8 = _slicedToArray(_useState7, 2),
          title = _useState8[0],
          setTitle = _useState8[1];

      var _useState9 = (0, _react.useState)(false),
          _useState10 = _slicedToArray(_useState9, 2),
          visible = _useState10[0],
          setVisible = _useState10[1];

      var isMounted = (0, _frontendJsReactWeb.useIsMounted)();
      var delay = (0, _frontendJsReactWeb.useTimeout)();
      var siteNavigationMenuEditorRef = (0, _react.useRef)();
      var namespace = Liferay.Util.getPortletNamespace(portletId);
      var openSidebar = (0, _react.useCallback)(function (title, url, requestBody) {
        if (changed) {
          var _confirm = confirmUnsavedChanges();

          if (_confirm) {
            return;
          }
        }

        setLoading(true);
        setTitle(title);
        setVisible(true);
        (0, _frontendJsWeb.fetch)(url, {
          body: (0, _frontendJsWeb.objectToFormData)(Liferay.Util.ns(namespace, requestBody)),
          method: 'POST'
        }).then(function (response) {
          return response.text();
        }).then(function (responseContent) {
          if (isMounted()) {
            setBody(responseContent);
            setChanged(false);
            setLoading(false);
          }
        });
      }, [isMounted, namespace, changed]);
      (0, _react.useEffect)(function () {
        if (!siteNavigationMenuEditorRef.current) {
          siteNavigationMenuEditorRef.current = new _SiteNavigationMenuEditor["default"]({
            editSiteNavigationMenuItemParentURL: editSiteNavigationMenuItemParentURL,
            namespace: namespace
          });
        }

        var handle = siteNavigationMenuEditorRef.current.on('selectedMenuItemChanged', function (event) {
          var _event$newVal$dataset = event.newVal.dataset,
              siteNavigationMenuItemId = _event$newVal$dataset.siteNavigationMenuItemId,
              title = _event$newVal$dataset.title;
          openSidebar(title, editSiteNavigationMenuItemURL, {
            redirect: redirect,
            siteNavigationMenuItemId: siteNavigationMenuItemId
          });
        });
        return function () {
          handle.removeListener();
          siteNavigationMenuEditorRef.current.dispose();
          siteNavigationMenuEditorRef.current = null;
        };
      }, [editSiteNavigationMenuItemParentURL, editSiteNavigationMenuItemURL, namespace, openSidebar, redirect]);
      (0, _react.useEffect)(function () {
        var settingsButton = document.getElementById("".concat(namespace, "showSiteNavigationMenuSettings"));

        if (settingsButton) {
          var handleSettingButtonClick = function handleSettingButtonClick() {
            openSidebar(siteNavigationMenuName, editSiteNavigationMenuSettingsURL, {
              redirect: redirect,
              siteNavigationMenuId: siteNavigationMenuId
            });
          };

          settingsButton.addEventListener('click', handleSettingButtonClick);
          return function () {
            return settingsButton.removeEventListener('click', handleSettingButtonClick);
          };
        }
      }, [editSiteNavigationMenuSettingsURL, namespace, openSidebar, redirect, siteNavigationMenuId, siteNavigationMenuName, visible]);

      var confirmUnsavedChanges = function confirmUnsavedChanges() {
        var form = document.querySelector(".sidebar-body form");
        var error = form ? form.querySelector('[role="alert"]') : null;
        var confirmChanged;

        if (!error) {
          confirmChanged = confirm(Liferay.Language.get('you-have-unsaved-changes.-do-you-want-to-save-them'));

          if (confirmChanged) {
            if (form) {
              form.submit();
            }
          }
        }

        return confirmChanged;
      };

      var closeSidebar = (0, _react.useCallback)(function () {
        setChanged(false);
        delay(function () {
          setVisible(false);
        }, 0);
      }, [delay]);
      return _react["default"].createElement("div", {
        className: "contextual-sidebar ".concat(visible ? 'contextual-sidebar-visible' : '', " sidebar sidebar-light"),
        id: "".concat(namespace, "sidebar")
      }, _react["default"].createElement("div", {
        className: "sidebar-header"
      }, _react["default"].createElement(_layout["default"].ContentRow, {
        className: "sidebar-section"
      }, _react["default"].createElement(_layout["default"].ContentCol, {
        expand: true
      }, _react["default"].createElement("p", {
        className: "component-title"
      }, _react["default"].createElement("span", {
        className: "text-truncate-inline"
      }, _react["default"].createElement("span", {
        className: "text-truncate"
      }, title)))), _react["default"].createElement(_layout["default"].ContentCol, null, _react["default"].createElement(_button["default"], {
        displayType: "unstyled",
        monospaced: true,
        onClick: function onClick() {
          if (changed) {
            confirmUnsavedChanges();
          }

          closeSidebar();
        }
      }, _react["default"].createElement(_icon["default"], {
        symbol: "times"
      }))))), _react["default"].createElement("div", {
        className: "sidebar-body"
      }, loading ? _react["default"].createElement(_loadingIndicator["default"], null) : _react["default"].createElement(SidebarBody, {
        body: body,
        onChange: function onChange() {
          return setChanged(true);
        }
      })));
    }

    var SidebarBody = /*#__PURE__*/function (_React$Component) {
      _inherits(SidebarBody, _React$Component);

      function SidebarBody(props) {
        var _this;

        _classCallCheck(this, SidebarBody);

        _this = _possibleConstructorReturn(this, _getPrototypeOf(SidebarBody).call(this, props));
        _this._handleOnChange = _this._handleOnChange.bind(_assertThisInitialized(_this));
        _this._ref = _react["default"].createRef();
        return _this;
      }

      _createClass(SidebarBody, [{
        key: "componentDidMount",
        value: function componentDidMount() {
          if (this._ref.current) {
            _metalDom.globalEval.runScriptsInElement(this._ref.current);

            this._ref.current.addEventListener('change', this._handleOnChange);
          }
        }
      }, {
        key: "componentWillUnmount",
        value: function componentWillUnmount() {
          if (this._ref.current) {
            this._ref.current.removeEventListener('change', this._handleOnChange);
          }
        }
      }, {
        key: "shouldComponentUpdate",
        value: function shouldComponentUpdate() {
          return false;
        }
      }, {
        key: "_handleOnChange",
        value: function _handleOnChange() {
          if (this.props.onChange) {
            this.props.onChange();
          }
        }
      }, {
        key: "render",
        value: function render() {
          return _react["default"].createElement("div", {
            dangerouslySetInnerHTML: {
              __html: this.props.body
            },
            ref: this._ref
          });
        }
      }]);

      return SidebarBody;
    }(_react["default"].Component);

    var _default = ContextualSidebar;
    exports["default"] = _default;
    //# sourceMappingURL=ContextualSidebar.js.map
  }
});
//# sourceMappingURL=ContextualSidebar.js.map