Liferay.Loader.define("site-navigation-admin-web@2.0.34/js/SiteNavigationMenuDOMHandler.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-position', './SiteNavigationMenuItemDOMHandler.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.shouldBeNested = exports.isOver = exports.insertAtTop = exports.insertAtPosition = exports.getNearestMenuItem = void 0;

  var _metalDom = require("frontend-js-metal-web$metal-dom");

  var _metalPosition = _interopRequireDefault(require("frontend-js-metal-web$metal-position"));

  var _SiteNavigationMenuItemDOMHandler = require("./SiteNavigationMenuItemDOMHandler.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */

  /**
   * Constant indicating how much a menuItem element should be moved
   * to the right in order to consider it nested to it's parent.
   */
  var NEST_THRESHOLD = 30;
  /**
   * Gets the nearest menuItem element for the given originMenuItem
   * and placeholder.
   *
   * The placeholder is used for retrieving the reference position, and
   * the originMenuItem for checking that child elements are being avoided.
   *
   * @param {HTMLElement} originMenuItem
   * @param {HTMLElement} placeholder
   * @return {HTMLElement}
   */

  var getNearestMenuItem = function getNearestMenuItem(originMenuItem, placeholder) {
    var container = (0, _metalDom.toElement)(".".concat(_SiteNavigationMenuItemDOMHandler.MENU_CONTAINER_CLASSNAME));
    var originMenuItemId = (0, _SiteNavigationMenuItemDOMHandler.getId)(originMenuItem);

    var originMenuItemRegion = _metalPosition["default"].getRegion(placeholder);

    return Array.prototype.slice.call(document.querySelectorAll(".".concat(_SiteNavigationMenuItemDOMHandler.MENU_ITEM_CLASSNAME))).filter(function (menuItem) {
      return (0, _metalDom.contains)(container, menuItem) && !(0, _metalDom.contains)(originMenuItem, menuItem) && (0, _SiteNavigationMenuItemDOMHandler.getId)(menuItem) !== originMenuItemId && !(0, _metalDom.hasClass)(menuItem, _SiteNavigationMenuItemDOMHandler.MENU_ITEM_DRAGGING_CLASSNAME);
    }).map(function (menuItem) {
      var menuItemRegion = _metalPosition["default"].getRegion(menuItem);

      var distance = Math.sqrt(Math.pow(originMenuItemRegion.left - menuItemRegion.left, 2) + Math.pow(originMenuItemRegion.top - menuItemRegion.top, 2));
      return {
        distance: distance,
        menuItem: menuItem,
        region: menuItemRegion
      };
    }).reduce(function (distanceA, distanceB) {
      return distanceA.distance < distanceB.distance ? distanceA : distanceB;
    }, {
      distance: Infinity,
      menuItem: null
    }).menuItem;
  };
  /**
   * Inserts the given menuItem as child of given parentMenuItem
   * at the given position.
   * @param {HTMLElement} parentMenuItem
   * @param {HTMLElement} menuItem
   * @param {number} position
   * @review
   */

  exports.getNearestMenuItem = getNearestMenuItem;

  var insertAtPosition = function insertAtPosition(parentMenuItem, menuItem, position) {
    var children = (0, _SiteNavigationMenuItemDOMHandler.getChildren)(parentMenuItem);

    if (position >= children.length) {
      parentMenuItem.appendChild(menuItem);
    } else {
      parentMenuItem.insertBefore(menuItem, children[position]);
    }
  };
  /**
   * Insert the given menuItem at the top of the navigation tree
   * @param {HTMLElement} menuItem
   */

  exports.insertAtPosition = insertAtPosition;

  var insertAtTop = function insertAtTop(menuItem) {
    var container = (0, _metalDom.toElement)(".".concat(_SiteNavigationMenuItemDOMHandler.MENU_CONTAINER_CLASSNAME));
    var children = (0, _SiteNavigationMenuItemDOMHandler.getChildren)(container);

    if (children.length) {
      container.insertBefore(menuItem, children[0]);
    } else {
      container.appendChild(menuItem);
    }
  };
  /**
   * Returns true if the first menuItem element is over
   * the second menuItem element.
   * @param {HTMLElement} menuItemA
   * @param {HTMLElement} menuItemB
   * @return {boolean}
   */

  exports.insertAtTop = insertAtTop;

  var isOver = function isOver(menuItemA, menuItemB) {
    var menuItemARegion = _metalPosition["default"].getRegion(menuItemA);

    var menuItemBRegion = _metalPosition["default"].getRegion(menuItemB);

    return menuItemARegion.top < menuItemBRegion.top;
  };
  /**
   * Returns true if the given menuItem element should be nested
   * inside the given parentMenuItem element by checking their positions.
   * @param {HTMLElement} menuItem
   * @param {HTMLElement} parentMenuItem
   * @return {boolean}
   */

  exports.isOver = isOver;

  var shouldBeNested = function shouldBeNested(menuItem, parentMenuItem) {
    var nested = false;

    if ((0, _SiteNavigationMenuItemDOMHandler.isMenuItem)(parentMenuItem)) {
      var menuItemRegion = _metalPosition["default"].getRegion(menuItem);

      var parentMenuItemRegion = _metalPosition["default"].getRegion(parentMenuItem);

      var nestedInParent = menuItemRegion.left > parentMenuItemRegion.left + NEST_THRESHOLD;
      var parentWithChildren = (0, _SiteNavigationMenuItemDOMHandler.getChildren)(parentMenuItem).filter(function (childMenuItem) {
        return (0, _SiteNavigationMenuItemDOMHandler.getId)(childMenuItem) !== (0, _SiteNavigationMenuItemDOMHandler.getId)(menuItem);
      }).length > 0;
      nested = nestedInParent || parentWithChildren;
    }

    return nested;
  };

  exports.shouldBeNested = shouldBeNested;
  //# sourceMappingURL=SiteNavigationMenuDOMHandler.es.js.map
});
//# sourceMappingURL=SiteNavigationMenuDOMHandler.es.js.map