Liferay.Loader.define("site-navigation-menu-web@1.0.6/metal-drag-drop/src/DragDrop", ['exports', 'metal/src/metal', 'metal-dom/src/all/dom', './Drag', 'metal-position/src/all/position', 'metal-events/src/events'], function (exports, _metal, _dom, _Drag2, _position) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.Drag = exports.DragDrop = undefined;

	var _dom2 = _interopRequireDefault(_dom);

	var _Drag3 = _interopRequireDefault(_Drag2);

	var _position2 = _interopRequireDefault(_position);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;
		var desc = Object.getOwnPropertyDescriptor(object, property);

		if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);

			if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;

			if (getter === undefined) {
				return undefined;
			}

			return getter.call(receiver);
		}
	};

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var DragDrop = function (_Drag) {
		_inherits(DragDrop, _Drag);

		/**
   * @inheritDoc
   */
		function DragDrop(config) {
			_classCallCheck(this, DragDrop);

			var _this = _possibleConstructorReturn(this, (DragDrop.__proto__ || Object.getPrototypeOf(DragDrop)).call(this, config));

			/**
    * The currently active targets, that is, the ones that the dragged source is over.
    * @type {!Array<!Element>}
    * @protected
    */
			_this.activeTargets_ = [];
			return _this;
		}

		/**
   * Adds a target to this `DragDrop` instance.
   * @param {!Element} target
   */


		_createClass(DragDrop, [{
			key: 'addTarget',
			value: function addTarget(target) {
				this.targets.push(target);
				this.targets = this.targets;
			}
		}, {
			key: 'buildEventObject_',
			value: function buildEventObject_() {
				var obj = _get(DragDrop.prototype.__proto__ || Object.getPrototypeOf(DragDrop.prototype), 'buildEventObject_', this).call(this);
				obj.target = this.activeTargets_[0];
				obj.allActiveTargets = this.activeTargets_;
				return obj;
			}
		}, {
			key: 'cleanUpAfterDragging_',
			value: function cleanUpAfterDragging_() {
				_get(DragDrop.prototype.__proto__ || Object.getPrototypeOf(DragDrop.prototype), 'cleanUpAfterDragging_', this).call(this);
				this.targets.forEach(function (target) {
					return target.removeAttribute('aria-dropeffect');
				});
				if (this.activeTargets_.length) {
					_dom2.default.removeClasses(this.activeTargets_[0], this.targetOverClass);
				}
				this.activeTargets_ = [];
			}
		}, {
			key: 'findAllActiveTargets_',
			value: function findAllActiveTargets_() {
				var activeTargets = [];
				var mainRegion = void 0;
				var sourceRegion = this.getSourceRegion_();
				var targets = this.targets;
				targets.forEach(function (target, index) {
					var region = _position2.default.getRegion(target);
					if (targets[index] !== this.activeDragPlaceholder_ && _position2.default.intersectRegion(region, sourceRegion)) {
						// eslint-disable-next-line
						if (!mainRegion || _position2.default.insideRegion(mainRegion, region)) {
							activeTargets = [targets[index]].concat(activeTargets);
							mainRegion = region;
						} else {
							activeTargets.push(targets[index]);
						}
					}
				}.bind(this));
				return activeTargets;
			}
		}, {
			key: 'getSourceRegion_',
			value: function getSourceRegion_() {
				if (_metal.core.isDefAndNotNull(this.mousePos_)) {
					var x = this.mousePos_.x;
					var y = this.mousePos_.y;
					return _position2.default.makeRegion(y, 0, x, x, y, 0);
				} else {
					// We need to remove the scroll data from the region, since the other regions we'll
					// be comparing to won't take that information into account.
					var region = _metal.object.mixin({}, this.sourceRegion_);
					region.left -= document.body.scrollLeft;
					region.right -= document.body.scrollLeft;
					region.top -= document.body.scrollTop;
					region.bottom -= document.body.scrollTop;
					return region;
				}
			}
		}, {
			key: 'handleContainerChanged_',
			value: function handleContainerChanged_(data, event) {
				_get(DragDrop.prototype.__proto__ || Object.getPrototypeOf(DragDrop.prototype), 'handleContainerChanged_', this).call(this, data, event);
				if (this.prevTargetsSelector_) {
					this.targets = this.prevTargetsSelector_;
				}
			}
		}, {
			key: 'removeTarget',
			value: function removeTarget(target) {
				_metal.array.remove(this.targets, target);
				this.targets = this.targets;
			}
		}, {
			key: 'setterTargetsFn_',
			value: function setterTargetsFn_(val) {
				this.prevTargetsSelector_ = _metal.core.isString(val) ? val : null;
				return this.toElements_(val);
			}
		}, {
			key: 'startDragging_',
			value: function startDragging_() {
				var _this2 = this;

				if (this.ariaDropEffect) {
					this.targets.forEach(function (target) {
						return target.setAttribute('aria-dropeffect', _this2.ariaDropEffect);
					});
				}
				_get(DragDrop.prototype.__proto__ || Object.getPrototypeOf(DragDrop.prototype), 'startDragging_', this).call(this);
			}
		}, {
			key: 'updatePosition',
			value: function updatePosition(deltaX, deltaY) {
				_get(DragDrop.prototype.__proto__ || Object.getPrototypeOf(DragDrop.prototype), 'updatePosition', this).call(this, deltaX, deltaY);

				var newTargets = this.findAllActiveTargets_();
				if (newTargets[0] !== this.activeTargets_[0]) {
					if (this.activeTargets_[0]) {
						_dom2.default.removeClasses(this.activeTargets_[0], this.targetOverClass);
						this.emit(DragDrop.Events.TARGET_LEAVE, this.buildEventObject_()); // eslint-disable-line
					}

					this.activeTargets_ = newTargets;
					if (this.activeTargets_[0]) {
						_dom2.default.addClasses(this.activeTargets_[0], this.targetOverClass);
						this.emit(DragDrop.Events.TARGET_ENTER, this.buildEventObject_()); // eslint-disable-line
					}
				}
			}
		}]);

		return DragDrop;
	}(_Drag3.default);

	/**
  * State definition.
  * @type {!Object}
  * @static
  */
	DragDrop.STATE = {
		/**
   * The "aria-dropeffect" value to be set for all targets. If not set,
   * this html attribute will have to be set manually on the targets.
   * @type {string}
   */
		ariaDropEffect: {
			validator: _metal.core.isString
		},

		/**
   * The CSS class that should be added to drop targets when a source
   * is being dragged over them.
   * @type {string}
   * @default 'dropOver'
   */
		targetOverClass: {
			validator: _metal.core.isString,
			value: 'targetOver'
		},

		/**
   * Elements that the sources can be dropped on. Can be either a single
   * element or a selector for multiple elements.
   * @type {!Element|string}
   */
		targets: {
			setter: 'setterTargetsFn_',
			validator: 'validateElementOrString_'
		}
	};

	/**
  * Holds the names of events that can be emitted by `DragDrop`.
  * @type {!Object}
  * @static
  */
	DragDrop.Events = {
		DRAG: 'drag',
		END: 'end',
		TARGET_ENTER: 'targetEnter',
		TARGET_LEAVE: 'targetLeave'
	};

	exports.DragDrop = DragDrop;
	exports.Drag = _Drag3.default;
	exports.default = DragDrop;
});
//# sourceMappingURL=DragDrop.js.map
