Liferay.Loader.define("site-navigation-menu-web@1.0.6/js/SiteNavigationMenuEditor.es", ['exports', 'metal-dom/src/all/dom', 'metal-drag-drop/src/all/drag', 'metal-state/src/all/state', './SiteNavigationMenu.es', './SiteNavigationMenuItem.es'], function (exports, _dom, _drag, _state, _SiteNavigationMenu, _SiteNavigationMenuItem) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.SiteNavigationMenuEditor = undefined;

	var _state2 = _interopRequireDefault(_state);

	var _SiteNavigationMenu2 = _interopRequireDefault(_SiteNavigationMenu);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;
		var desc = Object.getOwnPropertyDescriptor(object, property);

		if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);

			if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;

			if (getter === undefined) {
				return undefined;
			}

			return getter.call(receiver);
		}
	};

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var KEYS = {
		ARROW_DOWN: 'ArrowDown',
		ARROW_LEFT: 'ArrowLeft',
		ARROW_RIGHT: 'ArrowRight',
		ARROW_UP: 'ArrowUp',
		ENTER: 'Enter',
		SPACEBAR: ' '
	};

	/**
  *	Site navigation menu editor component.
  */

	var SiteNavigationMenuEditor = function (_State) {
		_inherits(SiteNavigationMenuEditor, _State);

		/**
   * @inheritDoc
   */

		function SiteNavigationMenuEditor(config) {
			var _ref;

			_classCallCheck(this, SiteNavigationMenuEditor);

			for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
				args[_key - 1] = arguments[_key];
			}

			var _this = _possibleConstructorReturn(this, (_ref = SiteNavigationMenuEditor.__proto__ || Object.getPrototypeOf(SiteNavigationMenuEditor)).call.apply(_ref, [this, config].concat(args)));

			_this.setState(config);

			_this._dragDrop = new _drag.DragDrop({
				dragPlaceholder: _drag.Drag.Placeholder.CLONE,
				handles: '.' + _SiteNavigationMenuItem.MENU_ITEM_DRAG_ICON_CLASSNAME,
				sources: '.' + _SiteNavigationMenuItem.MENU_ITEM_CLASSNAME,
				targets: '.' + _SiteNavigationMenuItem.MENU_ITEM_CLASSNAME
			});

			_this._dragDrop.on(_drag.DragDrop.Events.DRAG, _this._handleDragItem.bind(_this));

			_this._dragDrop.on(_drag.Drag.Events.START, _this._handleDragStart.bind(_this));

			_this._dragDrop.on(_drag.DragDrop.Events.END, _this._handleDropItem.bind(_this));

			_this._itemClickHandler = _dom.dom.on('.' + _SiteNavigationMenuItem.MENU_ITEM_CONTENT_CLASSNAME, 'click', _this._handleItemClick.bind(_this));

			_this._itemKeyUpHandler = _dom.dom.on('.' + _SiteNavigationMenuItem.MENU_ITEM_CLASSNAME, 'keyup', _this._handleItemKeyUp.bind(_this));
			return _this;
		}

		/**
   * @inheritDoc
   */

		_createClass(SiteNavigationMenuEditor, [{
			key: 'dispose',
			value: function dispose() {
				var _get2;

				if (this._dragDrop) {
					this._dragDrop.dispose();
					this._dragDrop = null;
				}

				if (this._itemClickHandler) {
					this._itemClickHandler.removeListener();
					this._itemClickHandler = null;
				}

				if (this._itemKeyUpHandler) {
					this._itemKeyUpHandler.removeListener();
					this._itemKeyUpHandler = null;
				}

				for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
					args[_key2] = arguments[_key2];
				}

				(_get2 = _get(SiteNavigationMenuEditor.prototype.__proto__ || Object.getPrototypeOf(SiteNavigationMenuEditor.prototype), 'dispose', this)).call.apply(_get2, [this].concat(args));
			}
		}, {
			key: '_handleDragItem',
			value: function _handleDragItem(data, event) {
				var placeholderMenuItem = data.placeholder;
				var sourceMenuItem = data.source;

				var nearestMenuItem = _SiteNavigationMenu2.default.getNearestMenuItem(sourceMenuItem, placeholderMenuItem);

				if (placeholderMenuItem && _SiteNavigationMenuItem.SiteNavigationMenuItem.isMenuItem(placeholderMenuItem) && sourceMenuItem && _SiteNavigationMenuItem.SiteNavigationMenuItem.isMenuItem(sourceMenuItem) && nearestMenuItem && _SiteNavigationMenuItem.SiteNavigationMenuItem.isMenuItem(nearestMenuItem)) {
					var nested = _SiteNavigationMenu2.default.shouldBeNested(placeholderMenuItem, nearestMenuItem);

					var over = _SiteNavigationMenu2.default.isOver(placeholderMenuItem, nearestMenuItem);

					if (!over && nested) {
						_SiteNavigationMenu2.default.insertAtPosition(nearestMenuItem, sourceMenuItem, 0);
					} else {
						var nearestMenuItemParent = _SiteNavigationMenuItem.SiteNavigationMenuItem.getParent(nearestMenuItem);

						var nearestMenuItemIndex = _SiteNavigationMenuItem.SiteNavigationMenuItem.getChildren(nearestMenuItemParent).indexOf(nearestMenuItem) + (over ? 0 : 1);

						_SiteNavigationMenu2.default.insertAtPosition(nearestMenuItemParent, sourceMenuItem, nearestMenuItemIndex);
					}
				}
			}
		}, {
			key: '_handleDragStart',
			value: function _handleDragStart(data, event) {
				var menuItem = event.target.getActiveDrag();

				_SiteNavigationMenuItem.SiteNavigationMenuItem.setDragging(menuItem, true);
			}
		}, {
			key: '_handleDropItem',
			value: function _handleDropItem(data, event) {
				event.preventDefault();

				var menuItem = data.source;
				var menuItemId = _SiteNavigationMenuItem.SiteNavigationMenuItem.getId(menuItem);

				var menuItemIndex = _SiteNavigationMenuItem.SiteNavigationMenuItem.getSiblings(menuItem).indexOf(menuItem);

				var menuItemParentId = _SiteNavigationMenuItem.SiteNavigationMenuItem.getId(_SiteNavigationMenuItem.SiteNavigationMenuItem.getParent(menuItem));

				this._updateParentAndOrder({
					dragOrder: menuItemIndex,
					parentId: menuItemParentId,
					siteNavigationMenuItemId: menuItemId
				});

				_SiteNavigationMenuItem.SiteNavigationMenuItem.setDragging(menuItem, false);
			}
		}, {
			key: '_handleItemClick',
			value: function _handleItemClick(event) {
				_SiteNavigationMenuItem.SiteNavigationMenuItem.setSelected(_SiteNavigationMenuItem.SiteNavigationMenuItem.getFromContentElement(event.delegateTarget), true);
			}
		}, {
			key: '_handleItemKeyUp',
			value: function _handleItemKeyUp(event) {
				event.stopPropagation();

				var menuItem = event.delegateTarget;
				var menuItemIndex = _SiteNavigationMenuItem.SiteNavigationMenuItem.getSiblings(menuItem).indexOf(menuItem);

				var menuItemParent = _SiteNavigationMenuItem.SiteNavigationMenuItem.getParent(menuItem);

				var layoutModified = false;

				if (event.key === KEYS.ENTER || event.key === KEYS.SPACEBAR) {
					menuItem.click();
				} else if (event.key === KEYS.ARROW_LEFT) {
					var menuItemParentIndex = _SiteNavigationMenuItem.SiteNavigationMenuItem.getSiblings(menuItemParent).indexOf(menuItemParent);

					var menuItemGrandParent = _SiteNavigationMenuItem.SiteNavigationMenuItem.getParent(menuItemParent);

					if (menuItemParentIndex !== -1) {
						_SiteNavigationMenu2.default.insertAtPosition(menuItemGrandParent, menuItem, menuItemParentIndex + 1);
					}

					layoutModified = true;
				} else if (event.key === KEYS.ARROW_UP && menuItemIndex > 0) {
					_SiteNavigationMenu2.default.insertAtPosition(menuItemParent, menuItem, menuItemIndex - 1);

					layoutModified = true;
				} else if (event.key === KEYS.ARROW_RIGHT && menuItemIndex > 0) {
					var previousSibling = _SiteNavigationMenuItem.SiteNavigationMenuItem.getSiblings(menuItem)[menuItemIndex - 1];

					_SiteNavigationMenu2.default.insertAtPosition(previousSibling, menuItem, Infinity);

					layoutModified = true;
				} else if (event.key === KEYS.ARROW_DOWN) {
					_SiteNavigationMenu2.default.insertAtPosition(menuItemParent, menuItem, menuItemIndex + 2);

					layoutModified = true;
				}

				if (layoutModified) {
					var siteNavigationMenuItemId = _SiteNavigationMenuItem.SiteNavigationMenuItem.getId(menuItem);

					this._updateParentAndOrder({
						dragOrder: _SiteNavigationMenuItem.SiteNavigationMenuItem.getSiblings(menuItem).indexOf(menuItem),

						parentId: _SiteNavigationMenuItem.SiteNavigationMenuItem.getId(_SiteNavigationMenuItem.SiteNavigationMenuItem.getParent(menuItem)),

						siteNavigationMenuItemId: siteNavigationMenuItemId
					});

					requestAnimationFrame(function () {
						var modifiedMenuItem = _SiteNavigationMenuItem.SiteNavigationMenuItem.getFromId(siteNavigationMenuItemId);

						modifiedMenuItem.focus();
					});
				}
			}
		}, {
			key: '_updateParentAndOrder',
			value: function _updateParentAndOrder(data) {
				var formData = new FormData();

				formData.append(this.namespace + 'siteNavigationMenuItemId', data.siteNavigationMenuItemId);

				formData.append(this.namespace + 'parentSiteNavigationMenuItemId', data.parentId);

				formData.append(this.namespace + 'order', data.dragOrder);

				return fetch(this.editSiteNavigationMenuItemParentURL, {
					body: formData,
					credentials: 'include',
					method: 'POST'
				});
			}
		}]);

		return SiteNavigationMenuEditor;
	}(_state2.default);

	/**
  * State definition.
  * @type {!Object}
  * @static
  */

	SiteNavigationMenuEditor.STATE = {

		/**
   * URL for edit site navigation menu item parent action.
   *
   * @default undefined
   * @instance
   * @memberOf SiteNavigationMenuEditor
   * @type {!string}
   */

		editSiteNavigationMenuItemParentURL: _state.Config.string().required(),

		/**
   * Portlet namespace to use in edit action.
   *
   * @default undefined
   * @instance
   * @memberOf SiteNavigationMenuEditor
   * @type {!string}
   */

		namespace: _state.Config.string().required(),

		/**
   * Internal DragDrop instance.
   *
   * @default null
   * @instance
   * @memberOf SiteNavigationMenuEditor
   * @type {State}
   */

		_dragDrop: _state.Config.internal().value(null)
	};

	exports.SiteNavigationMenuEditor = SiteNavigationMenuEditor;
	exports.default = SiteNavigationMenuEditor;
});
//# sourceMappingURL=SiteNavigationMenuEditor.es.js.map
