Liferay.Loader.define("site-navigation-menu-web@1.0.21/js/SiteNavigationMenuItemDOMHandler.es", ['exports', 'metal-dom/src/all/dom'], function (exports, _dom) {
  'use strict';

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.unselectAll = exports.setSelected = exports.setDragging = exports.isSelected = exports.isMenuItem = exports.isChildOf = exports.getSiblings = exports.getParent = exports.getNextSibling = exports.getId = exports.getFromId = exports.getFromContentElement = exports.getChildren = exports.MENU_ITEM_DRAGGING_CLASSNAME = exports.MENU_ITEM_DRAG_ICON_CLASSNAME = exports.MENU_ITEM_CLASSNAME = exports.MENU_ITEM_CONTENT_CLASSNAME = exports.MENU_CONTAINER_CLASSNAME = undefined;


  var MENU_CONTAINER_CLASSNAME = 'site-navigation-menu-container';

  var MENU_ITEM_CLASSNAME = 'site-navigation-menu-item';

  var MENU_ITEM_CONTENT_CLASSNAME = MENU_ITEM_CLASSNAME + '__content';

  var MENU_ITEM_DRAGGING_CLASSNAME = MENU_ITEM_CLASSNAME + '--dragging';

  var MENU_ITEM_DRAG_ICON_CLASSNAME = MENU_ITEM_CLASSNAME + '__drag-icon';

  var MENU_ITEM_SELECTED_CLASSNAME = MENU_ITEM_CLASSNAME + '--selected';

  /**
   * Returns an array with the menuItem children of the given menuItem.
   * @param {HTMLElement} menuItem
   * @return {Array<HTMLElement>}
   * @review
   */

  var getChildren = function getChildren(menuItem) {
    return Array.prototype.slice.call(menuItem.children).filter(function (child) {
      return (0, _dom.hasClass)(child, MENU_ITEM_CLASSNAME);
    });
  };

  /**
   * Returns a menuItem element, parent of a given menuItemContent.
   * @param {HTMLElement} menuItemContent
   * @return {HTMLElement|null}
   * @review
   */

  var getFromContentElement = function getFromContentElement(menuItemContent) {
    return (0, _dom.closest)(menuItemContent, '.' + MENU_ITEM_CLASSNAME);
  };

  /**
   * Returns a menuItem element with the given ID
   * @param {number|string} menuItemId
   * @return {HTMLElement|null}
   */

  var getFromId = function getFromId(menuItemId) {
    return document.querySelector('.' + MENU_ITEM_CLASSNAME + '[data-site-navigation-menu-item-id="' + menuItemId + '"]');
  };

  /**
   * Gets the ID of a given menuItem element.
   * @param {HTMLElement} menuItem
   * @return {number}
   */

  var getId = function getId(menuItem) {
    return parseInt(menuItem.dataset.siteNavigationMenuItemId, 10) || 0;
  };

  /**
   * Returns the next menuItem sibling of a given menuItem element.
   * @param {HTMLElement} menuItem
   * @return {HTMLElement|null}
   */

  var getNextSibling = function getNextSibling(menuItem) {
    (0, _dom.next)(menuItem, '.' + MENU_ITEM_CLASSNAME);
  };

  /**
   * Returns a menuItem element, parent of a given menuItem.
   * @param {HTMLElement} menuItem
   * @return {HTMLElement|null}
   * @review
   */

  var getParent = function getParent(menuItem) {
    return menuItem.parentElement;
  };

  /**
   * For a given menuItem element, returns it's sibblings
   * @param {HTMLElement} menuItem
   * @return {Array<HTMLElement>}
   * @review
   */

  var getSiblings = function getSiblings(menuItem) {
    var parentElement = menuItem.parentElement;
    var siblings = [];

    if (parentElement) {
      siblings = getChildren(parentElement);
    }

    return siblings;
  };

  /**
   * Returns true if the given menuItem is child of the given parentMenuItem
   * @param {HTMLElement} menuItem
   * @param {HTMLElement} parentMenuItem
   * @return {boolean}
   */

  var isChildOf = function isChildOf(menuItem, parentMenuItem) {
    return (0, _dom.contains)(parentMenuItem, menuItem);
  };

  /**
   * Returns true if the given htmlElement is a menuItem, false otherwise.
   * @param {HTMLElement} htmlElement
   * @return {boolean}
   */

  var isMenuItem = function isMenuItem(htmlElement) {
    return (0, _dom.hasClass)(htmlElement, MENU_ITEM_CLASSNAME);
  };

  /**
   * Returns true if the given menuItem element is selected, false otherwise
   * @param {HTMLElement} menuItem
   * @return {boolean}
   */

  var isSelected = function isSelected(menuItem) {
    return (0, _dom.hasClass)(menuItem, MENU_ITEM_SELECTED_CLASSNAME);
  };

  /**
   * Mutates the given menuItem element by changing it's status
   * to dragging/not dragging.
   * @param {HTMLElement} menuItem
   */

  var setDragging = function setDragging(menuItem) {
    var dragging = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

    if (dragging) {
      (0, _dom.addClasses)(menuItem, MENU_ITEM_DRAGGING_CLASSNAME);
    } else {
      (0, _dom.removeClasses)(menuItem, MENU_ITEM_DRAGGING_CLASSNAME);
    }
  };

  /**
   * Mutates the given menuItem by changing it's status
   * to selected. Only a single menuItem can be
   * selected, so any other selected menuItem will be unselected.
   *
   * @param {!HTMLElement} menuItem
   */

  var setSelected = function setSelected(menuItem) {
    unselectAll();
    (0, _dom.addClasses)(menuItem, MENU_ITEM_SELECTED_CLASSNAME);
  };

  /**
   * Mutates all selected menuItems and set their
   * status to unselected.
   */

  var unselectAll = function unselectAll() {
    var selectedMenuItem = (0, _dom.toElement)('.' + MENU_ITEM_SELECTED_CLASSNAME);

    if (selectedMenuItem) {
      (0, _dom.removeClasses)(selectedMenuItem, MENU_ITEM_SELECTED_CLASSNAME);
    }
  };

  exports.MENU_CONTAINER_CLASSNAME = MENU_CONTAINER_CLASSNAME;
  exports.MENU_ITEM_CONTENT_CLASSNAME = MENU_ITEM_CONTENT_CLASSNAME;
  exports.MENU_ITEM_CLASSNAME = MENU_ITEM_CLASSNAME;
  exports.MENU_ITEM_DRAG_ICON_CLASSNAME = MENU_ITEM_DRAG_ICON_CLASSNAME;
  exports.MENU_ITEM_DRAGGING_CLASSNAME = MENU_ITEM_DRAGGING_CLASSNAME;
  exports.getChildren = getChildren;
  exports.getFromContentElement = getFromContentElement;
  exports.getFromId = getFromId;
  exports.getId = getId;
  exports.getNextSibling = getNextSibling;
  exports.getParent = getParent;
  exports.getSiblings = getSiblings;
  exports.isChildOf = isChildOf;
  exports.isMenuItem = isMenuItem;
  exports.isSelected = isSelected;
  exports.setDragging = setDragging;
  exports.setSelected = setSelected;
  exports.unselectAll = unselectAll;
});
//# sourceMappingURL=SiteNavigationMenuItemDOMHandler.es.js.map
