Liferay.Loader.define("site-navigation-menu-web@1.0.21/js/SiteNavigationMenuEditor.es", ['exports', 'metal-dom/src/all/dom', 'metal-drag-drop/src/all/drag', 'metal-position/src/all/position', 'metal-state/src/all/state', 'metal-throttle/src/throttle', './SiteNavigationMenuDOMHandler.es', './SiteNavigationMenuItemDOMHandler.es'], function (exports, _dom, _drag, _position, _state, _throttle, _SiteNavigationMenuDOMHandler, _SiteNavigationMenuItemDOMHandler) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.SiteNavigationMenuEditor = undefined;

	var _position2 = _interopRequireDefault(_position);

	var _state2 = _interopRequireDefault(_state);

	var _throttle2 = _interopRequireDefault(_throttle);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;
		var desc = Object.getOwnPropertyDescriptor(object, property);

		if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);

			if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;

			if (getter === undefined) {
				return undefined;
			}

			return getter.call(receiver);
		}
	};

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Document height.
  * @review
  */

	var DOCUMENT_HEIGHT = document.body.offsetHeight;

	/**
  * List of keys used for moving elements with keyboard.
  * @review
  */

	var KEYS = {
		ARROW_DOWN: 'ArrowDown',
		ARROW_LEFT: 'ArrowLeft',
		ARROW_RIGHT: 'ArrowRight',
		ARROW_UP: 'ArrowUp',
		ENTER: 'Enter',
		SPACEBAR: ' '
	};

	/**
  * Distance the window moves on scroll.
  * @review
  */

	var SCROLL_DISPLACEMENT = 100;

	/**
  * Window height
  * @review
  */

	var WINDOW_HEIGHT = window.innerHeight;

	/**
  * Margin on window top and bottom in which scroll starts.
  * @review
  */

	var SCROLL_MARGIN = WINDOW_HEIGHT * 0.2;

	/**
  * SiteNavigationMenuEditor
  * @review
  */

	var SiteNavigationMenuEditor = function (_State) {
		_inherits(SiteNavigationMenuEditor, _State);

		/**
   * @inheritDoc
   * @review
   */

		function SiteNavigationMenuEditor(config) {
			var _ref;

			_classCallCheck(this, SiteNavigationMenuEditor);

			for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
				args[_key - 1] = arguments[_key];
			}

			var _this = _possibleConstructorReturn(this, (_ref = SiteNavigationMenuEditor.__proto__ || Object.getPrototypeOf(SiteNavigationMenuEditor)).call.apply(_ref, [this, config].concat(args)));

			var controlMenu = document.querySelector('.control-menu');
			_this._controlMenuHeight = controlMenu ? controlMenu.offsetHeight : 0;

			var managementBar = document.querySelector('.management-bar');
			_this._managementBarHeight = managementBar ? managementBar.offsetHeight : 0;

			_this._scrollOnDrag = (0, _throttle2.default)(_this._scrollOnDrag.bind(_this), 250);
			_this._scrollOnDragLoop = _this._scrollOnDragLoop.bind(_this);

			_this.setState(config);

			_this._dragDrop = new _drag.DragDrop({
				dragPlaceholder: _drag.Drag.Placeholder.CLONE,
				handles: '.' + _SiteNavigationMenuItemDOMHandler.MENU_ITEM_DRAG_ICON_CLASSNAME,
				sources: '.' + _SiteNavigationMenuItemDOMHandler.MENU_ITEM_CLASSNAME,
				targets: '.' + _SiteNavigationMenuItemDOMHandler.MENU_ITEM_CLASSNAME
			});

			_this._dragDrop.on(_drag.DragDrop.Events.DRAG, _this._handleDragItem.bind(_this));

			_this._dragDrop.on(_drag.Drag.Events.START, _this._handleDragStart.bind(_this));

			_this._dragDrop.on(_drag.DragDrop.Events.END, _this._handleDropItem.bind(_this));

			_this._itemClickHandler = _dom.dom.on('.' + _SiteNavigationMenuItemDOMHandler.MENU_ITEM_CONTENT_CLASSNAME, 'click', _this._handleItemClick.bind(_this));

			_this._itemKeyUpHandler = _dom.dom.on('.' + _SiteNavigationMenuItemDOMHandler.MENU_ITEM_CLASSNAME, 'keyup', _this._handleItemKeyUp.bind(_this));

			_this.on('selectedMenuItemChanged', _this._handleSelectedMenuItemChanged.bind(_this));
			return _this;
		}

		/**
   * @inheritDoc
   * @review
   */

		_createClass(SiteNavigationMenuEditor, [{
			key: 'dispose',
			value: function dispose() {
				var _get2;

				if (this._dragDrop) {
					this._dragDrop.dispose();
					this._dragDrop = null;
				}

				if (this._itemClickHandler) {
					this._itemClickHandler.removeListener();
					this._itemClickHandler = null;
				}

				if (this._itemKeyUpHandler) {
					this._itemKeyUpHandler.removeListener();
					this._itemKeyUpHandler = null;
				}

				for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
					args[_key2] = arguments[_key2];
				}

				(_get2 = _get(SiteNavigationMenuEditor.prototype.__proto__ || Object.getPrototypeOf(SiteNavigationMenuEditor.prototype), 'dispose', this)).call.apply(_get2, [this].concat(args));
			}
		}, {
			key: '_scrollOnDrag',
			value: function _scrollOnDrag() {
				if (this._currentYPosition < this._draggedItemRegion.top && this._draggedItemRegion.top > WINDOW_HEIGHT - SCROLL_MARGIN && this._draggedItemRegion.bottom + window.scrollY < DOCUMENT_HEIGHT + this._draggedItemRegion.height) {
					window.scrollTo({
						behavior: 'smooth',
						top: window.scrollY + SCROLL_DISPLACEMENT
					});
				} else if (this._currentYPosition > this._draggedItemRegion.top && this._draggedItemRegion.top < this._controlMenuHeight + this._managementBarHeight + SCROLL_MARGIN) {
					window.scrollTo({
						behavior: 'smooth',
						top: window.scrollY - SCROLL_DISPLACEMENT
					});
				}

				this._currentYPosition = this._draggedItemRegion.top;
			}
		}, {
			key: '_scrollOnDragLoop',
			value: function _scrollOnDragLoop() {
				this._scrollOnDrag(this._draggedItemRegion);
				this._scrollAnimationId = requestAnimationFrame(this._scrollOnDragLoop);
			}
		}, {
			key: '_handleDragItem',
			value: function _handleDragItem(data, event) {
				var placeholderMenuItem = data.placeholder;
				var sourceMenuItem = data.source;

				var nearestMenuItem = (0, _SiteNavigationMenuDOMHandler.getNearestMenuItem)(sourceMenuItem, placeholderMenuItem);

				if (!this._draggedItemRegion) {
					this._draggedItemRegion = _position2.default.getRegion(placeholderMenuItem);
					this._scrollOnDragLoop();
				}

				this._draggedItemRegion = _position2.default.getRegion(placeholderMenuItem);

				if (placeholderMenuItem && (0, _SiteNavigationMenuItemDOMHandler.isMenuItem)(placeholderMenuItem) && sourceMenuItem && (0, _SiteNavigationMenuItemDOMHandler.isMenuItem)(sourceMenuItem) && nearestMenuItem && (0, _SiteNavigationMenuItemDOMHandler.isMenuItem)(nearestMenuItem)) {
					var nested = (0, _SiteNavigationMenuDOMHandler.shouldBeNested)(placeholderMenuItem, nearestMenuItem);

					var over = (0, _SiteNavigationMenuDOMHandler.isOver)(placeholderMenuItem, nearestMenuItem);

					if (!over && nested) {
						(0, _SiteNavigationMenuDOMHandler.insertAtPosition)(nearestMenuItem, sourceMenuItem, 0);
					} else {
						var nearestMenuItemParent = (0, _SiteNavigationMenuItemDOMHandler.getParent)(nearestMenuItem);

						var nearestMenuItemIndex = (0, _SiteNavigationMenuItemDOMHandler.getChildren)(nearestMenuItemParent).indexOf(nearestMenuItem) + (over ? 0 : 1);

						(0, _SiteNavigationMenuDOMHandler.insertAtPosition)(nearestMenuItemParent, sourceMenuItem, nearestMenuItemIndex);
					}
				}
			}
		}, {
			key: '_handleDragStart',
			value: function _handleDragStart(data, event) {
				var menuItem = event.target.getActiveDrag();

				this.selectedMenuItem = menuItem;

				(0, _SiteNavigationMenuItemDOMHandler.setDragging)(menuItem, true);
			}
		}, {
			key: '_handleDropItem',
			value: function _handleDropItem(data, event) {
				event.preventDefault();

				var menuItem = data.source;
				var menuItemId = (0, _SiteNavigationMenuItemDOMHandler.getId)(menuItem);

				var menuItemIndex = (0, _SiteNavigationMenuItemDOMHandler.getSiblings)(menuItem).indexOf(menuItem);

				var menuItemParentId = (0, _SiteNavigationMenuItemDOMHandler.getId)((0, _SiteNavigationMenuItemDOMHandler.getParent)(menuItem));

				cancelAnimationFrame(this._scrollAnimationId);
				this._scrollAnimationId = -1;
				this._draggedItemRegion = null;

				this._updateParentAndOrder({
					dragOrder: menuItemIndex,
					parentId: menuItemParentId,
					siteNavigationMenuItemId: menuItemId
				});

				(0, _SiteNavigationMenuItemDOMHandler.setDragging)(menuItem, false);
			}
		}, {
			key: '_handleItemClick',
			value: function _handleItemClick(event) {
				var menuItem = (0, _SiteNavigationMenuItemDOMHandler.getFromContentElement)(event.delegateTarget);

				this.selectedMenuItem = menuItem;
			}
		}, {
			key: '_handleItemKeyUp',
			value: function _handleItemKeyUp(event) {
				event.stopPropagation();

				var menuItem = event.delegateTarget;
				var menuItemIndex = (0, _SiteNavigationMenuItemDOMHandler.getSiblings)(menuItem).indexOf(menuItem);

				var menuItemParent = (0, _SiteNavigationMenuItemDOMHandler.getParent)(menuItem);

				var layoutModified = false;

				if (event.key === KEYS.ENTER || event.key === KEYS.SPACEBAR) {
					this.selectedMenuItem = menuItem;
				} else if (event.key === KEYS.ARROW_LEFT) {
					var menuItemParentIndex = (0, _SiteNavigationMenuItemDOMHandler.getSiblings)(menuItemParent).indexOf(menuItemParent);

					var menuItemGrandParent = (0, _SiteNavigationMenuItemDOMHandler.getParent)(menuItemParent);

					if (menuItemParentIndex !== -1) {
						(0, _SiteNavigationMenuDOMHandler.insertAtPosition)(menuItemGrandParent, menuItem, menuItemParentIndex + 1);
					}

					layoutModified = true;
				} else if (event.key === KEYS.ARROW_UP && menuItemIndex > 0) {
					(0, _SiteNavigationMenuDOMHandler.insertAtPosition)(menuItemParent, menuItem, menuItemIndex - 1);

					layoutModified = true;
				} else if (event.key === KEYS.ARROW_RIGHT && menuItemIndex > 0) {
					var previousSibling = (0, _SiteNavigationMenuItemDOMHandler.getSiblings)(menuItem)[menuItemIndex - 1];

					(0, _SiteNavigationMenuDOMHandler.insertAtPosition)(previousSibling, menuItem, Infinity);

					layoutModified = true;
				} else if (event.key === KEYS.ARROW_DOWN) {
					(0, _SiteNavigationMenuDOMHandler.insertAtPosition)(menuItemParent, menuItem, menuItemIndex + 2);

					layoutModified = true;
				}

				if (layoutModified) {
					var siteNavigationMenuItemId = (0, _SiteNavigationMenuItemDOMHandler.getId)(menuItem);

					this._updateParentAndOrder({
						dragOrder: (0, _SiteNavigationMenuItemDOMHandler.getSiblings)(menuItem).indexOf(menuItem),

						parentId: (0, _SiteNavigationMenuItemDOMHandler.getId)((0, _SiteNavigationMenuItemDOMHandler.getParent)(menuItem)),

						siteNavigationMenuItemId: siteNavigationMenuItemId
					});

					requestAnimationFrame(function () {
						var modifiedMenuItem = (0, _SiteNavigationMenuItemDOMHandler.getFromId)(siteNavigationMenuItemId);

						modifiedMenuItem.focus();
					});
				}
			}
		}, {
			key: '_handleSelectedMenuItemChanged',
			value: function _handleSelectedMenuItemChanged(event) {
				(0, _SiteNavigationMenuItemDOMHandler.unselectAll)();

				if (event.newVal) {
					(0, _SiteNavigationMenuItemDOMHandler.setSelected)(event.newVal);
				}
			}
		}, {
			key: '_updateParentAndOrder',
			value: function _updateParentAndOrder(data) {
				var formData = new FormData();

				formData.append(this.namespace + 'siteNavigationMenuItemId', data.siteNavigationMenuItemId);

				formData.append(this.namespace + 'parentSiteNavigationMenuItemId', data.parentId);

				formData.append(this.namespace + 'order', data.dragOrder);

				return fetch(this.editSiteNavigationMenuItemParentURL, {
					body: formData,
					credentials: 'include',
					method: 'POST'
				});
			}
		}]);

		return SiteNavigationMenuEditor;
	}(_state2.default);

	/**
  * State definition.
  * @review
  * @static
  * @type {!Object}
  */

	SiteNavigationMenuEditor.STATE = {

		/**
   * URL for edit site navigation menu item parent action.
   * @default undefined
   * @instance
   * @memberOf SiteNavigationMenuEditor
   * @review
   * @type {!string}
   */

		editSiteNavigationMenuItemParentURL: _state.Config.string().required(),

		/**
   * Portlet namespace to use in edit action.
   * @default undefined
   * @instance
   * @memberOf SiteNavigationMenuEditor
   * @review
   * @type {!string}
   */

		namespace: _state.Config.string().required(),

		/**
   * Selected menuItem DOM element.
   * @default null
   * @instance
   * @memberOf SiteNavigationMenuEditor
   * @review
   * @type {HTMLElement}
   */

		selectedMenuItem: _state.Config.object().value(null),

		/**
   * Control menu height.
   * @default 0
   * @instance
   * @memberOf SiteNavigationMenuEditor
   * @private
   * @review
   * @type {number}
   */

		_controlMenuHeight: _state.Config.number().internal().value(0),

		/**
   * @default -1
   * @instance
   * @memberOf SiteNavigationMenuEditor
   * @private
   * @review
   * @type {number}
   */

		_currentYPosition: _state.Config.number().internal().value(-1),

		/**
   * Internal DragDrop instance.
   * @default null
   * @instance
   * @memberOf SiteNavigationMenuEditor
   * @review
   * @type {object|null}
   */

		_dragDrop: _state.Config.internal().value(null),

		/**
   * Dragged item.
   * @default undefined
   * @instance
   * @memberOf SiteNavigationMenuEditor
   * @private
   * @review
   * @type {HTMLElement|null}
   */

		_draggedItemRegion: _state.Config.object().internal(),

		/**
   * Management bar height
   * @default 0
   * @instance
   * @memberOf SiteNavigationMenuEditor
   * @private
   * @review
   * @type {number}
   */

		_managementBarHeight: _state.Config.number().internal().value(0),

		/**
   * @default -1
   * @instance
   * @memberOf SiteNavigationMenuEditor
   * @private
   * @review
   * @type {number}
   */

		_scrollAnimationId: _state.Config.number().internal().value(-1)

	};

	exports.SiteNavigationMenuEditor = SiteNavigationMenuEditor;
	exports.default = SiteNavigationMenuEditor;
});
//# sourceMappingURL=SiteNavigationMenuEditor.es.js.map
