/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.initializer.extender.internal.util;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;

public class SiteInitializerUtil {
    private static final String[] _PORTAL_PROPERTIES_KEYS_WHITELIST = new String[]{"default.guest.public.layout.friendly.url", "default.guest.public.layout.name", "default.guest.public.layout.regular.color.scheme.id", "default.guest.public.layout.regular.theme.id", "default.guest.public.layout.template.id"};
    private static final Pattern _portalPropertyPattern = Pattern.compile("\\[\\$PORTAL_PROPERTY:((?!\\.)(?!.*\\.\\.)[a-zA-Z0-9_.]+)\\$\\]");

    public static String read(Bundle bundle, String fileName, URL url) throws Exception {
        String urlPath = url.getPath();
        URL entryURL = bundle.getEntry(urlPath.substring(0, urlPath.lastIndexOf("/") + 1) + fileName);
        try (InputStream inputStream = entryURL.openStream();){
            String string = StringUtil.read((InputStream)entryURL.openStream());
            return string;
        }
    }

    public static String read(String resourcePath, ServletContext servletContext) throws Exception {
        try (InputStream inputStream = servletContext.getResourceAsStream(resourcePath);){
            if (inputStream == null) {
                String string = null;
                return string;
            }
            String content = StringUtil.read((InputStream)inputStream);
            Map<String, String> portalPropertiesStringUtilReplaceValues = SiteInitializerUtil._getPortalPropertiesStringUtilReplaceValues(content);
            String string = StringUtil.replace((String)content, (String)"[$", (String)"$]", portalPropertiesStringUtilReplaceValues);
            return string;
        }
    }

    public static Map<Locale, String> toMap(String values) {
        return SiteInitializerUtil.toMap("", values);
    }

    public static Map<Locale, String> toMap(String prefix, String values) {
        if (Validator.isBlank((String)values)) {
            return Collections.emptyMap();
        }
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        Map valuesMap = (Map)ObjectMapperUtil.readValue(HashMap.class, (String)values);
        for (Map.Entry entry : valuesMap.entrySet()) {
            map.put(LocaleUtil.fromLanguageId((String)((String)entry.getKey())), prefix + (String)entry.getValue());
        }
        return map;
    }

    private static Map<String, String> _getPortalPropertiesStringUtilReplaceValues(String content) {
        HashMap<String, String> portalPropertiesStringUtilReplaceValues = new HashMap<String, String>();
        if (Validator.isNull((String)content)) {
            return portalPropertiesStringUtilReplaceValues;
        }
        Matcher matcher = _portalPropertyPattern.matcher(content);
        while (matcher.find()) {
            String portalProperty = matcher.group();
            String[] portalPropertyParts = StringUtil.split((String)(portalProperty = portalProperty.substring(2, portalProperty.length() - 2)), (char)':');
            String value = PropsUtil.get((String)portalPropertyParts[1]);
            if (value == null || !ArrayUtil.contains((Object[])_PORTAL_PROPERTIES_KEYS_WHITELIST, (Object)portalPropertyParts[1])) {
                value = "";
            }
            portalPropertiesStringUtilReplaceValues.put(portalProperty, value);
        }
        return portalPropertiesStringUtilReplaceValues;
    }
}

