/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.internal.struts;

import com.liferay.portal.kernel.exception.NoSuchLayoutSetException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.VirtualHostLocalService;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.site.manager.SitemapManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"path=/portal/sitemap"}, service={StrutsAction.class})
public class SitemapStrutsAction
implements StrutsAction {
    private static final Log _log = LogFactoryUtil.getLog(SitemapStrutsAction.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SitemapManager _sitemapManager;
    @Reference
    private VirtualHostLocalService _virtualHostLocalService;

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
            LayoutSet layoutSet = null;
            if (groupId > 0L) {
                Group group = this._groupLocalService.getGroup(groupId);
                if (group.isStagingGroup()) {
                    groupId = group.getLiveGroupId();
                }
                boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"privateLayout");
                layoutSet = this._layoutSetLocalService.getLayoutSet(groupId, privateLayout);
            } else {
                String host = this._portal.getHost(httpServletRequest);
                host = StringUtil.toLowerCase((String)host);
                VirtualHost virtualHost = this._virtualHostLocalService.fetchVirtualHost(host = host.trim());
                if (virtualHost != null && virtualHost.getLayoutSetId() != 0L) {
                    layoutSet = this._layoutSetLocalService.getLayoutSet(virtualHost.getLayoutSetId());
                    Group group = layoutSet.getGroup();
                    if (group.isStagingGroup()) {
                        GroupPermissionUtil.check((PermissionChecker)themeDisplay.getPermissionChecker(), (long)group.getGroupId(), (String)"VIEW_STAGING");
                    }
                } else {
                    String groupName = PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME;
                    if (Validator.isNull((String)groupName)) {
                        groupName = "Guest";
                    }
                    Group group = this._groupLocalService.getGroup(themeDisplay.getCompanyId(), groupName);
                    layoutSet = this._layoutSetLocalService.getLayoutSet(group.getGroupId(), false);
                }
            }
            Group currentGroup = this._groupLocalService.getGroup(layoutSet.getGroupId());
            if (!currentGroup.isActive()) {
                throw new NoSuchLayoutSetException();
            }
            String layoutUuid = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"layoutUuid");
            String sitemap = this._sitemapManager.getSitemap(layoutUuid, layoutSet.getGroupId(), layoutSet.isPrivateLayout(), themeDisplay);
            ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, null, (byte[])sitemap.getBytes("UTF-8"), (String)"text/xml; charset=UTF-8");
        }
        catch (NoSuchLayoutSetException noSuchLayoutSetException) {
            this._portal.sendError(404, (Exception)((Object)noSuchLayoutSetException), httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            this._portal.sendError(500, exception, httpServletRequest, httpServletResponse);
        }
        return null;
    }
}

