/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.internal.exportimport.staged.model.repository;

import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.layout.set.model.adapter.StagedLayoutSet;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.adapter.util.ModelAdapterUtil;
import com.liferay.site.model.adapter.StagedGroup;
import java.util.ArrayList;
import java.util.List;

public class StagedGroupStagedModelRepositoryUtil {
    private static final Log _log = LogFactoryUtil.getLog(StagedGroupStagedModelRepositoryUtil.class);
    private static final Snapshot<GroupLocalService> _groupLocalServiceSnapshot = new Snapshot(StagedGroupStagedModelRepositoryUtil.class, GroupLocalService.class);
    private static final Snapshot<LayoutSetLocalService> _layoutSetLocalServiceSnapshot = new Snapshot(StagedGroupStagedModelRepositoryUtil.class, LayoutSetLocalService.class);

    public static List<StagedModel> fetchChildrenStagedModels(PortletDataContext portletDataContext, StagedGroup stagedGroup) {
        ArrayList<StagedModel> childrenStagedModels = new ArrayList<StagedModel>();
        Group group = stagedGroup.getGroup();
        long groupId = group.getGroupId();
        try {
            LayoutSetLocalService layoutSetLocalService = (LayoutSetLocalService)_layoutSetLocalServiceSnapshot.get();
            childrenStagedModels.add((StagedModel)ModelAdapterUtil.adapt((Object)layoutSetLocalService.getLayoutSet(groupId, portletDataContext.isPrivateLayout()), LayoutSet.class, StagedLayoutSet.class));
        }
        catch (PortalException portalException) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to fetch Layout Set with groupId ", groupId, " and private layout ", portletDataContext.isPrivateLayout()}), (Throwable)portalException);
        }
        return childrenStagedModels;
    }

    public static Group fetchExistingGroup(PortletDataContext portletDataContext, Element referenceElement) {
        long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
        long liveGroupId = GetterUtil.getLong((String)referenceElement.attributeValue("live-group-id"));
        if (groupId == 0L || liveGroupId == 0L) {
            return null;
        }
        String groupKey = GetterUtil.getString((String)referenceElement.attributeValue("group-key"));
        return StagedGroupStagedModelRepositoryUtil.fetchExistingGroup(portletDataContext, groupId, liveGroupId, groupKey);
    }

    public static Group fetchExistingGroup(PortletDataContext portletDataContext, long groupId, long liveGroupId) {
        return StagedGroupStagedModelRepositoryUtil.fetchExistingGroup(portletDataContext, groupId, liveGroupId, null);
    }

    public static Group fetchExistingGroup(PortletDataContext portletDataContext, long groupId, long liveGroupId, String groupKey) {
        Group groupKeyGroup;
        GroupLocalService groupLocalService = (GroupLocalService)_groupLocalServiceSnapshot.get();
        Group liveGroup = groupLocalService.fetchGroup(liveGroupId);
        if (liveGroup != null && liveGroup.getCompanyId() == portletDataContext.getCompanyId()) {
            return liveGroup;
        }
        long existingGroupId = 0L;
        if (groupId == portletDataContext.getSourceCompanyGroupId()) {
            existingGroupId = portletDataContext.getCompanyGroupId();
        } else if (groupId == portletDataContext.getSourceGroupId()) {
            existingGroupId = portletDataContext.getGroupId();
        } else if (Validator.isNotNull((String)groupKey) && (groupKeyGroup = groupLocalService.fetchGroup(portletDataContext.getCompanyId(), groupKey)) != null) {
            existingGroupId = groupKeyGroup.getGroupId();
        }
        Group group = groupLocalService.fetchGroup(existingGroupId);
        if (group != null && group.getCompanyId() == portletDataContext.getCompanyId()) {
            return group;
        }
        return groupLocalService.fetchGroup(portletDataContext.getScopeGroupId());
    }
}

