/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.internal.configuration.manager;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.site.configuration.manager.SitemapConfigurationManager;
import com.liferay.site.internal.configuration.SitemapCompanyConfiguration;
import com.liferay.site.internal.configuration.SitemapGroupConfiguration;
import java.util.Dictionary;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SitemapConfigurationManager.class})
public class SitemapConfigurationManagerImpl
implements SitemapConfigurationManager {
    @Reference
    private ConfigurationProvider _configurationProvider;

    public Long[] getCompanySitemapGroupIds(long companyId) throws Exception {
        SitemapCompanyConfiguration sitemapCompanyConfiguration = (SitemapCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(SitemapCompanyConfiguration.class, companyId);
        return (Long[])TransformUtil.transform((Object[])sitemapCompanyConfiguration.companySitemapGroupIds(), GetterUtil::getLong, Long.class);
    }

    public boolean includeCategoriesCompanyEnabled(long companyId) throws ConfigurationException {
        SitemapCompanyConfiguration sitemapCompanyConfiguration = (SitemapCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(SitemapCompanyConfiguration.class, companyId);
        return sitemapCompanyConfiguration.includeCategories();
    }

    public boolean includeCategoriesGroupEnabled(long companyId, long groupId) throws ConfigurationException {
        if (!this.includeCategoriesCompanyEnabled(companyId)) {
            return false;
        }
        SitemapGroupConfiguration sitemapGroupConfiguration = (SitemapGroupConfiguration)this._configurationProvider.getGroupConfiguration(SitemapGroupConfiguration.class, groupId);
        return sitemapGroupConfiguration.includeCategories();
    }

    public boolean includePagesCompanyEnabled(long companyId) throws ConfigurationException {
        SitemapCompanyConfiguration sitemapCompanyConfiguration = (SitemapCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(SitemapCompanyConfiguration.class, companyId);
        return sitemapCompanyConfiguration.includePages();
    }

    public boolean includePagesGroupEnabled(long companyId, long groupId) throws ConfigurationException {
        if (!this.includePagesCompanyEnabled(companyId)) {
            return false;
        }
        SitemapGroupConfiguration sitemapGroupConfiguration = (SitemapGroupConfiguration)this._configurationProvider.getGroupConfiguration(SitemapGroupConfiguration.class, groupId);
        return sitemapGroupConfiguration.includePages();
    }

    public boolean includeWebContentCompanyEnabled(long companyId) throws ConfigurationException {
        SitemapCompanyConfiguration sitemapCompanyConfiguration = (SitemapCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(SitemapCompanyConfiguration.class, companyId);
        return sitemapCompanyConfiguration.includeWebContent();
    }

    public boolean includeWebContentGroupEnabled(long companyId, long groupId) throws ConfigurationException {
        if (!this.includeWebContentCompanyEnabled(companyId)) {
            return false;
        }
        SitemapGroupConfiguration sitemapGroupConfiguration = (SitemapGroupConfiguration)this._configurationProvider.getGroupConfiguration(SitemapGroupConfiguration.class, groupId);
        return sitemapGroupConfiguration.includeWebContent();
    }

    public void saveSitemapCompanyConfiguration(long companyId, long[] companySitemapGroupIds, boolean includeCategories, boolean includePages, boolean includeWebContent, boolean xmlSitemapIndexEnabled) throws ConfigurationException {
        this._configurationProvider.saveCompanyConfiguration(SitemapCompanyConfiguration.class, companyId, (Dictionary)HashMapDictionaryBuilder.put((Object)"companySitemapGroupIds", (Object)companySitemapGroupIds).put((Object)"includeCategories", (Object)includeCategories).put((Object)"includePages", (Object)includePages).put((Object)"includeWebContent", (Object)includeWebContent).put((Object)"xmlSitemapIndexEnabled", (Object)xmlSitemapIndexEnabled).build());
    }

    public void saveSitemapGroupConfiguration(long groupId, boolean includeCategories, boolean includePages, boolean includeWebContent) throws ConfigurationException {
        this._configurationProvider.saveGroupConfiguration(SitemapGroupConfiguration.class, groupId, (Dictionary)HashMapDictionaryBuilder.put((Object)"includeCategories", (Object)includeCategories).put((Object)"includePages", (Object)includePages).put((Object)"includeWebContent", (Object)includeWebContent).build());
    }

    public boolean xmlSitemapIndexCompanyEnabled(long companyId) throws ConfigurationException {
        SitemapCompanyConfiguration sitemapCompanyConfiguration = (SitemapCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(SitemapCompanyConfiguration.class, companyId);
        return sitemapCompanyConfiguration.xmlSitemapIndexEnabled();
    }
}

