/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.internal.configuration.manager;

import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.site.configuration.MenuAccessConfiguration;
import com.liferay.site.configuration.manager.MenuAccessConfigurationManager;
import java.util.Dictionary;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={MenuAccessConfigurationManager.class})
public class MenuAccessConfigurationManagerImpl
implements MenuAccessConfigurationManager {
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private GroupLocalService _groupLocalService;

    public void addAccessRoleToControlMenu(Role role) throws Exception {
        for (Group group : this._groupLocalService.getGroups(role.getCompanyId(), -1L, true)) {
            MenuAccessConfiguration menuAccessConfiguration = (MenuAccessConfiguration)this._configurationProvider.getGroupConfiguration(MenuAccessConfiguration.class, group.getGroupId());
            if (!menuAccessConfiguration.showControlMenuByRole()) continue;
            String roleId = String.valueOf(role.getRoleId());
            Object[] accessToControlMenuRoleIds = menuAccessConfiguration.accessToControlMenuRoleIds();
            if (ArrayUtil.contains((Object[])accessToControlMenuRoleIds, (Object)roleId)) continue;
            accessToControlMenuRoleIds = (String[])ArrayUtil.append((Object[])accessToControlMenuRoleIds, (Object)roleId);
            this.updateMenuAccessConfiguration(group.getGroupId(), (String[])accessToControlMenuRoleIds, menuAccessConfiguration.showControlMenuByRole());
        }
    }

    public void deleteRoleAccessToControlMenu(Role role) throws Exception {
        for (Group group : this._groupLocalService.getGroups(role.getCompanyId(), -1L, true)) {
            MenuAccessConfiguration menuAccessConfiguration = (MenuAccessConfiguration)this._configurationProvider.getGroupConfiguration(MenuAccessConfiguration.class, group.getGroupId());
            String roleId = String.valueOf(role.getRoleId());
            Object[] accessToControlMenuRoleIds = menuAccessConfiguration.accessToControlMenuRoleIds();
            if (!ArrayUtil.contains((Object[])accessToControlMenuRoleIds, (Object)roleId)) continue;
            accessToControlMenuRoleIds = ArrayUtil.remove((String[])accessToControlMenuRoleIds, (String)roleId);
            this.updateMenuAccessConfiguration(group.getGroupId(), (String[])accessToControlMenuRoleIds, menuAccessConfiguration.showControlMenuByRole());
        }
    }

    public String[] getAccessToControlMenuRoleIds(long groupId) throws Exception {
        MenuAccessConfiguration menuAccessConfiguration = (MenuAccessConfiguration)this._configurationProvider.getGroupConfiguration(MenuAccessConfiguration.class, groupId);
        return menuAccessConfiguration.accessToControlMenuRoleIds();
    }

    public boolean isShowControlMenuByRole(long groupId) throws Exception {
        MenuAccessConfiguration menuAccessConfiguration = (MenuAccessConfiguration)this._configurationProvider.getGroupConfiguration(MenuAccessConfiguration.class, groupId);
        return menuAccessConfiguration.showControlMenuByRole();
    }

    public void updateMenuAccessConfiguration(long groupId, String[] accessToControlMenuRoleIds, boolean showControlMenuByRole) throws Exception {
        this._configurationProvider.saveGroupConfiguration(MenuAccessConfiguration.class, groupId, (Dictionary)HashMapDictionaryBuilder.put((Object)"accessToControlMenuRoleIds", (Object)accessToControlMenuRoleIds).put((Object)"showControlMenuByRole", (Object)showControlMenuByRole).build());
    }
}

