/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.browser.web.display.context;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.usersadmin.search.GroupSearch;
import com.liferay.portlet.usersadmin.search.GroupSearchTerms;
import com.liferay.sites.kernel.util.SitesUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class SiteBrowserDisplayContext {
    private static final long[] _CLASS_NAME_IDS = new long[]{PortalUtil.getClassNameId(Group.class), PortalUtil.getClassNameId(Organization.class)};
    private String _displayStyle;
    private String _filter;
    private Long _groupId;
    private LinkedHashMap<String, Object> _groupParams;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private Boolean _manualMembership;
    private Boolean _privateLayout;
    private final HttpServletRequest _request;
    private String _type;
    private String[] _types;

    public SiteBrowserDisplayContext(HttpServletRequest request, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        this._request = request;
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this._request);
        this._displayStyle = portalPreferences.getValue("com_liferay_site_browser_web_portlet_SiteBrowserPortlet", "display-style", "list");
        return this._displayStyle;
    }

    public String getFilter() {
        if (this._filter != null) {
            return this._filter;
        }
        this._filter = ParamUtil.getString((HttpServletRequest)this._request, (String)"filter");
        return this._filter;
    }

    public long getGroupId() {
        if (this._groupId != null) {
            return this._groupId;
        }
        this._groupId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"groupId");
        return this._groupId;
    }

    public LinkedHashMap<String, Object> getGroupParams() throws PortalException {
        if (this._groupParams != null) {
            return this._groupParams;
        }
        long groupId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"groupId");
        boolean includeCurrentGroup = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"includeCurrentGroup", (boolean)true);
        String type = this.getType();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        User user = themeDisplay.getUser();
        boolean filterManageableGroups = true;
        if (permissionChecker.isCompanyAdmin()) {
            filterManageableGroups = false;
        }
        this._groupParams = new LinkedHashMap();
        this._groupParams.put("active", Boolean.TRUE);
        if (this.isManualMembership().booleanValue()) {
            this._groupParams.put("manualMembership", Boolean.TRUE);
        }
        if (type.equals("child-sites")) {
            Group parentGroup = GroupLocalServiceUtil.getGroup((long)groupId);
            ArrayList<Group> parentGroups = new ArrayList<Group>();
            parentGroups.add(parentGroup);
            this._groupParams.put("groupsTree", parentGroups);
        } else if (filterManageableGroups) {
            this._groupParams.put("usersGroups", user.getUserId());
        }
        this._groupParams.put("site", Boolean.TRUE);
        if (!includeCurrentGroup && groupId > 0L) {
            ArrayList<Long> excludedGroupIds = new ArrayList<Long>();
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (group.isStagingGroup()) {
                excludedGroupIds.add(group.getLiveGroupId());
            } else {
                excludedGroupIds.add(groupId);
            }
            this._groupParams.put("excludedGroupIds", excludedGroupIds);
        }
        return this._groupParams;
    }

    public GroupSearch getGroupSearch() throws Exception {
        String type;
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        GroupSearch groupSearch = new GroupSearch((PortletRequest)this._liferayPortletRequest, this.getPortletURL());
        GroupSearchTerms groupSearchTerms = (GroupSearchTerms)groupSearch.getSearchTerms();
        ArrayList<Group> results = new ArrayList<Group>();
        int additionalSites = 0;
        int total = 0;
        boolean includeCompany = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"includeCompany");
        boolean includeUserPersonalSite = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"includeUserPersonalSite");
        long[] classNameIds = _CLASS_NAME_IDS;
        if (includeCompany) {
            classNameIds = ArrayUtil.append((long[])classNameIds, (long)PortalUtil.getClassNameId(Company.class));
        }
        if (includeUserPersonalSite) {
            if (groupSearch.getStart() == 0) {
                Group userPersonalSite = GroupLocalServiceUtil.getGroup((long)company.getCompanyId(), (String)"User Personal Site");
                results.add(userPersonalSite);
            }
            ++additionalSites;
        }
        if ((type = this.getType()).equals("layoutScopes")) {
            total = GroupLocalServiceUtil.getGroupsCount((long)themeDisplay.getCompanyId(), (String)Layout.class.getName(), (long)this.getGroupId());
        } else if (!type.equals("parent-sites")) {
            total = GroupLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (long[])classNameIds, (String)groupSearchTerms.getKeywords(), this.getGroupParams());
        }
        groupSearch.setTotal(total += additionalSites);
        int start = groupSearch.getStart();
        if (groupSearch.getStart() > additionalSites) {
            start = groupSearch.getStart() - additionalSites;
        }
        int end = groupSearch.getEnd() - additionalSites;
        List<Group> groups = null;
        if (type.equals("layoutScopes")) {
            groups = GroupLocalServiceUtil.getGroups((long)company.getCompanyId(), (String)Layout.class.getName(), (long)this.getGroupId(), (int)start, (int)end);
            groups = this._filterLayoutGroups(groups, this.isPrivateLayout());
        } else if (type.equals("parent-sites")) {
            Group group = GroupLocalServiceUtil.getGroup((long)this.getGroupId());
            groups = group.getAncestors();
            String filter = this.getFilter();
            if (Validator.isNotNull((String)filter)) {
                groups = this._filterGroups(groups, filter);
            }
            total = groups.size();
            groupSearch.setTotal(total += additionalSites);
        } else {
            groups = GroupLocalServiceUtil.search((long)company.getCompanyId(), (long[])classNameIds, (String)groupSearchTerms.getKeywords(), this.getGroupParams(), (int)start, (int)end, (OrderByComparator)groupSearch.getOrderByComparator());
        }
        results.addAll(groups);
        groupSearch.setResults(results);
        return groupSearch;
    }

    public PortletURL getPortletURL() throws PortalException {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        User selUser = PortalUtil.getSelectedUser((HttpServletRequest)this._request);
        if (selUser != null) {
            portletURL.setParameter("p_u_i_d", String.valueOf(selUser.getUserId()));
        }
        long[] selectedGroupIds = StringUtil.split((String)ParamUtil.getString((HttpServletRequest)this._request, (String)"selectedGroupIds"), (long)0L);
        boolean includeCompany = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"includeCompany");
        boolean includeCurrentGroup = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"includeCurrentGroup", (boolean)true);
        boolean includeUserPersonalSite = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"includeUserPersonalSite");
        String eventName = ParamUtil.getString((HttpServletRequest)this._request, (String)"eventName", (String)(this._liferayPortletResponse.getNamespace() + "selectSite"));
        String target = ParamUtil.getString((HttpServletRequest)this._request, (String)"target");
        portletURL.setParameter("groupId", String.valueOf(this.getGroupId()));
        portletURL.setParameter("selectedGroupIds", StringUtil.merge((long[])selectedGroupIds));
        portletURL.setParameter("type", this.getType());
        portletURL.setParameter("types", this.getTypes());
        portletURL.setParameter("displayStyle", this.getDisplayStyle());
        portletURL.setParameter("filter", this.getFilter());
        portletURL.setParameter("includeCompany", String.valueOf(includeCompany));
        portletURL.setParameter("includeCurrentGroup", String.valueOf(includeCurrentGroup));
        portletURL.setParameter("includeUserPersonalSite", String.valueOf(includeUserPersonalSite));
        portletURL.setParameter("manualMembership", String.valueOf(this.isManualMembership()));
        portletURL.setParameter("eventName", eventName);
        portletURL.setParameter("target", target);
        return portletURL;
    }

    public String getType() {
        if (this._type != null) {
            return this._type;
        }
        this._type = ParamUtil.getString((HttpServletRequest)this._request, (String)"type");
        String[] types = this.getTypes();
        if (Validator.isNull((String)this._type)) {
            this._type = types[0];
        }
        return this._type;
    }

    public String[] getTypes() {
        if (this._types != null) {
            return this._types;
        }
        this._types = ParamUtil.getParameterValues((HttpServletRequest)this._request, (String)"types");
        if (this._types.length == 0) {
            this._types = new String[]{"sites-that-i-administer"};
        }
        return this._types;
    }

    public Boolean isManualMembership() {
        if (this._manualMembership != null) {
            return this._manualMembership;
        }
        this._manualMembership = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"manualMembership");
        return this._manualMembership;
    }

    public Boolean isPrivateLayout() {
        if (this._privateLayout != null) {
            return this._privateLayout;
        }
        this._privateLayout = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"privateLayout");
        return this._privateLayout;
    }

    private List<Group> _filterGroups(List<Group> groups, String filter) throws Exception {
        ArrayList<Group> filteredGroups = new ArrayList<Group>();
        for (Group group : groups) {
            if (!filter.equals("contentSharingWithChildrenEnabled") || !SitesUtil.isContentSharingWithChildrenEnabled((Group)group)) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    private List<Group> _filterLayoutGroups(List<Group> groups, Boolean privateLayout) throws Exception {
        ArrayList<Group> filteredGroups = new ArrayList<Group>();
        if (privateLayout == null) {
            return groups;
        }
        for (Group group : groups) {
            Layout layout;
            if (!group.isLayout() || (layout = LayoutLocalServiceUtil.getLayout((long)group.getClassPK())).isPrivateLayout() != privateLayout.booleanValue()) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }
}

