/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.search;

import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.membershippolicy.OrganizationMembershipPolicyUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;

public class OrganizationRoleUserChecker
extends RowChecker {
    private static final Log _log = LogFactoryUtil.getLog(OrganizationRoleUserChecker.class);
    private final Organization _organization;
    private final Role _role;

    public OrganizationRoleUserChecker(RenderResponse renderResponse, Organization organization, Role role) {
        super((PortletResponse)renderResponse);
        this._organization = organization;
        this._role = role;
    }

    public boolean isChecked(Object object) {
        User user = (User)object;
        try {
            return UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)user.getUserId(), (long)this._organization.getGroupId(), (long)this._role.getRoleId());
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    public boolean isDisabled(Object object) {
        User user = (User)object;
        try {
            if (this.isChecked(user) ? OrganizationMembershipPolicyUtil.isRoleProtected((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (long)user.getUserId(), (long)this._organization.getOrganizationId(), (long)this._role.getRoleId()) || OrganizationMembershipPolicyUtil.isRoleRequired((long)user.getUserId(), (long)this._organization.getOrganizationId(), (long)this._role.getRoleId()) : !OrganizationMembershipPolicyUtil.isRoleAllowed((long)user.getUserId(), (long)this._organization.getOrganizationId(), (long)this._role.getRoleId())) {
                return true;
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        return super.isDisabled(object);
    }
}

