/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.admin.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupServiceUtil;
import com.liferay.portal.kernel.service.MembershipRequestLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.BreadcrumbEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.sitesadmin.search.SiteChecker;
import com.liferay.portlet.usersadmin.search.GroupSearch;
import com.liferay.site.admin.web.internal.servlet.taglib.util.SiteActionDropdownItemsProvider;
import com.liferay.site.util.GroupSearchProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class SiteAdminDisplayContext {
    private String _displayStyle;
    private Group _group;
    private long _groupId;
    private final GroupSearchProvider _groupSearchProvider;
    private final HttpServletRequest _httpServletRequest;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;

    public SiteAdminDisplayContext(HttpServletRequest httpServletRequest, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        this._httpServletRequest = httpServletRequest;
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._groupSearchProvider = (GroupSearchProvider)httpServletRequest.getAttribute("GROUP_SEARCH_PROVIDER");
    }

    public List<DropdownItem> getActionDropdownItems(Group group) throws Exception {
        SiteActionDropdownItemsProvider siteActionDropdownItemsProvider = new SiteActionDropdownItemsProvider(group, this._liferayPortletRequest, this._liferayPortletResponse, this);
        return siteActionDropdownItemsProvider.getActionDropdownItems();
    }

    public List<BreadcrumbEntry> getBreadcrumbEntries() throws PortalException {
        ArrayList<BreadcrumbEntry> breadcrumbEntries = new ArrayList<BreadcrumbEntry>();
        BreadcrumbEntry breadcrumbEntry = new BreadcrumbEntry();
        breadcrumbEntry.setTitle(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"sites"));
        PortletURL mainURL = this._liferayPortletResponse.createRenderURL();
        mainURL.setParameter("mvcPath", "/view.jsp");
        breadcrumbEntry.setURL(mainURL.toString());
        breadcrumbEntries.add(breadcrumbEntry);
        Group group = this.getGroup();
        if (group == null) {
            return breadcrumbEntries;
        }
        List ancestorGroups = group.getAncestors();
        Collections.reverse(ancestorGroups);
        for (Group ancestorGroup : ancestorGroups) {
            breadcrumbEntry = new BreadcrumbEntry();
            breadcrumbEntry.setTitle(ancestorGroup.getDescriptiveName());
            mainURL.setParameter("groupId", String.valueOf(ancestorGroup.getGroupId()));
            breadcrumbEntry.setURL(mainURL.toString());
            breadcrumbEntries.add(breadcrumbEntry);
        }
        Group unescapedGroup = (Group)group.toUnescapedModel();
        breadcrumbEntry = new BreadcrumbEntry();
        breadcrumbEntry.setTitle(unescapedGroup.getDescriptiveName());
        mainURL.setParameter("groupId", String.valueOf(unescapedGroup.getGroupId()));
        breadcrumbEntry.setURL(mainURL.toString());
        breadcrumbEntries.add(breadcrumbEntry);
        return breadcrumbEntries;
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle", (String)"list");
        return this._displayStyle;
    }

    public Group getGroup() throws PortalException {
        long groupId = this.getGroupId();
        if (groupId > 0L) {
            this._group = GroupServiceUtil.getGroup((long)groupId);
        }
        return this._group;
    }

    public long getGroupId() {
        if (this._groupId <= 0L) {
            this._groupId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"groupId", (long)0L);
        }
        return this._groupId;
    }

    public int getOrganizationsCount(Group group) {
        LinkedHashMap<String, Long> organizationParams = new LinkedHashMap<String, Long>();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        organizationParams.put("groupOrganization", group.getGroupId());
        organizationParams.put("organizationsGroups", group.getGroupId());
        return OrganizationLocalServiceUtil.searchCount((long)company.getCompanyId(), (long)-1L, null, null, null, null, organizationParams);
    }

    public int getPendingRequestsCount(Group group) {
        int pendingRequests = 0;
        if (group.getType() == 2) {
            pendingRequests = MembershipRequestLocalServiceUtil.searchCount((long)group.getGroupId(), (int)0);
        }
        return pendingRequests;
    }

    public PortletURL getPortletURL() {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("groupId", String.valueOf(this.getGroupId()));
        portletURL.setParameter("displayStyle", this.getDisplayStyle());
        return portletURL;
    }

    public GroupSearch getSearchContainer() throws PortalException {
        GroupSearch groupSearch = this._groupSearchProvider.getGroupSearch((PortletRequest)this._liferayPortletRequest, this.getPortletURL());
        groupSearch.setId("sites");
        SiteChecker siteChecker = new SiteChecker((PortletResponse)this._liferayPortletResponse);
        StringBundler sb = new StringBundler(5);
        sb.append("^(?!.*");
        sb.append(this._liferayPortletResponse.getNamespace());
        sb.append("redirect).*(groupId=");
        sb.append(this.getGroupId());
        sb.append(")");
        siteChecker.setRememberCheckBoxStateURLRegex(sb.toString());
        groupSearch.setRowChecker((RowChecker)siteChecker);
        return groupSearch;
    }

    public int getUserGroupsCount(Group group) {
        LinkedHashMap<String, Long> userGroupParams = new LinkedHashMap<String, Long>();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        userGroupParams.put("userGroupsGroups", group.getGroupId());
        return UserGroupLocalServiceUtil.searchCount((long)company.getCompanyId(), null, userGroupParams);
    }

    public int getUsersCount(Group group) {
        LinkedHashMap<String, Comparable<Boolean>> userParams = new LinkedHashMap<String, Comparable<Boolean>>();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        userParams.put("inherit", Boolean.TRUE);
        userParams.put("usersGroups", Long.valueOf(group.getGroupId()));
        return UserLocalServiceUtil.searchCount((long)company.getCompanyId(), null, (int)0, userParams);
    }

    public boolean hasAddChildSitePermission(Group group) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        return !group.isCompany() && (PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"ADD_COMMUNITY") || GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"ADD_COMMUNITY"));
    }
}

