/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.admin.web.internal.display.context;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.service.LayoutSetPrototypeServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.site.admin.web.internal.display.context.comparator.SiteInitializerNameComparator;
import com.liferay.site.admin.web.internal.util.SiteInitializerItem;
import com.liferay.site.initializer.SiteInitializer;
import com.liferay.site.initializer.SiteInitializerRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class SelectSiteInitializerDisplayContext {
    private String _backURL;
    private final HttpServletRequest _httpServletRequest;
    private Long _parentGroupId;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final SiteInitializerRegistry _siteInitializerRegistry;

    public SelectSiteInitializerDisplayContext(HttpServletRequest httpServletRequest, RenderRequest renderRequest, RenderResponse renderResponse) {
        this._httpServletRequest = httpServletRequest;
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._siteInitializerRegistry = (SiteInitializerRegistry)httpServletRequest.getAttribute("SITE_INITIALIZER_REGISTRY");
    }

    public String getBackURL() {
        if (this._backURL != null) {
            return this._backURL;
        }
        String redirect = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"redirect");
        this._backURL = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"backURL", (String)redirect);
        return this._backURL;
    }

    public long getParentGroupId() {
        if (this._parentGroupId != null) {
            return this._parentGroupId;
        }
        this._parentGroupId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"parentGroupId");
        return this._parentGroupId;
    }

    public SearchContainer getSearchContainer() throws PortalException {
        SearchContainer siteInitializerItemSearchContainer = new SearchContainer((PortletRequest)this._renderRequest, this._getPortletURL(), null, "there-are-no-site-templates");
        List siteInitializerItems = this._getSiteInitializerItems();
        siteInitializerItemSearchContainer.setTotal(siteInitializerItems.size());
        siteInitializerItems = ListUtil.subList(siteInitializerItems, (int)siteInitializerItemSearchContainer.getStart(), (int)siteInitializerItemSearchContainer.getEnd());
        siteInitializerItemSearchContainer.setResults(siteInitializerItems);
        return siteInitializerItemSearchContainer;
    }

    private PortletURL _getPortletURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/site/select_site_initializer");
        portletURL.setParameter("redirect", this.getBackURL());
        return portletURL;
    }

    private List<SiteInitializerItem> _getSiteInitializerItems() throws PortalException {
        ArrayList<SiteInitializerItem> siteInitializerItems = new ArrayList<SiteInitializerItem>();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        List layoutSetPrototypes = LayoutSetPrototypeServiceUtil.search((long)themeDisplay.getCompanyId(), (Boolean)Boolean.TRUE, null);
        for (LayoutSetPrototype layoutSetPrototype : layoutSetPrototypes) {
            siteInitializerItems.add(new SiteInitializerItem(layoutSetPrototype, themeDisplay.getLocale()));
        }
        List siteInitializers = this._siteInitializerRegistry.getSiteInitializers(themeDisplay.getCompanyId());
        for (SiteInitializer siteInitializer : siteInitializers) {
            SiteInitializerItem siteInitializerItem = new SiteInitializerItem(siteInitializer, themeDisplay.getLocale());
            siteInitializerItems.add(siteInitializerItem);
        }
        siteInitializerItems = ListUtil.sort(siteInitializerItems, (Comparator)((Object)new SiteInitializerNameComparator(true)));
        return siteInitializerItems;
    }
}

