/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.admin.web.internal.asset.model;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseAssetRendererFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.site.admin.web.internal.asset.model.SiteAssetRenderer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AssetRendererFactory.class})
public class SiteAssetRendererFactory
extends BaseAssetRendererFactory<Group> {
    public static final String TYPE = "site";
    private GroupLocalService _groupLocalService;

    public SiteAssetRendererFactory() {
        this.setSearchable(false);
        this.setSelectable(false);
    }

    public AssetRenderer<Group> getAssetRenderer(long classPK, int type) throws PortalException {
        Group group = this._groupLocalService.getGroup(classPK);
        SiteAssetRenderer siteAssetRenderer = new SiteAssetRenderer(group);
        if (siteAssetRenderer != null) {
            siteAssetRenderer.setAssetRendererType(type);
            return siteAssetRenderer;
        }
        return null;
    }

    public AssetRenderer<Group> getAssetRenderer(long groupId, String urlTitle) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        return new SiteAssetRenderer(group);
    }

    public String getClassName() {
        return Group.class.getName();
    }

    public String getIconCssClass() {
        return TYPE;
    }

    public String getType() {
        return TYPE;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }
}

