/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.admin.web.internal.servlet.taglib.ui;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.servlet.taglib.ui.FormNavigatorEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.site.admin.web.internal.servlet.taglib.ui.BaseSiteFormNavigatorEntry;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"form.navigator.entry.order:Integer=10"}, service={FormNavigatorEntry.class})
public class SiteSiteTemplateFormNavigatorEntry
extends BaseSiteFormNavigatorEntry {
    private static final Log _log = LogFactoryUtil.getLog(SiteSiteTemplateFormNavigatorEntry.class);
    private LayoutSetLocalService _layoutSetLocalService;
    private LayoutSetPrototypeLocalService _layoutSetPrototypeLocalService;

    public String getCategoryKey() {
        return "general";
    }

    public String getKey() {
        return "site-template";
    }

    public String getLabel(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)"site-template");
    }

    public boolean isVisible(User user, Group group) {
        if (group == null || group.isCompany()) {
            return false;
        }
        LayoutSet privateLayoutSet = null;
        LayoutSet publicLayoutSet = null;
        try {
            privateLayoutSet = this._layoutSetLocalService.getLayoutSet(group.getGroupId(), true);
            publicLayoutSet = this._layoutSetLocalService.getLayoutSet(group.getGroupId(), false);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return false;
        }
        if (privateLayoutSet == null && publicLayoutSet == null) {
            return false;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        LayoutSetPrototype privateLayoutSetPrototype = null;
        if (Validator.isNotNull((String)privateLayoutSet.getLayoutSetPrototypeUuid())) {
            privateLayoutSetPrototype = this._layoutSetPrototypeLocalService.fetchLayoutSetPrototypeByUuidAndCompanyId(privateLayoutSet.getLayoutSetPrototypeUuid(), themeDisplay.getCompanyId());
        }
        LayoutSetPrototype publicLayoutSetPrototype = null;
        if (Validator.isNotNull((String)publicLayoutSet.getLayoutSetPrototypeUuid())) {
            publicLayoutSetPrototype = this._layoutSetPrototypeLocalService.fetchLayoutSetPrototypeByUuidAndCompanyId(publicLayoutSet.getLayoutSetPrototypeUuid(), themeDisplay.getCompanyId());
        }
        return publicLayoutSetPrototype != null || privateLayoutSetPrototype != null;
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.site.admin.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
    }

    protected String getJspPath() {
        return "/site/site_template.jsp";
    }

    @Reference(unbind="-")
    protected void setLayoutSetLocalService(LayoutSetLocalService layoutSetLocalService) {
        this._layoutSetLocalService = layoutSetLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutSetPrototypeLocalService(LayoutSetPrototypeLocalService layoutSetPrototypeLocalService) {
        this._layoutSetPrototypeLocalService = layoutSetPrototypeLocalService;
    }
}

