/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.admin.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetPrototypeServiceUtil;
import com.liferay.portal.kernel.service.MembershipRequestLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.usersadmin.search.GroupSearch;
import com.liferay.site.admin.web.internal.display.context.SiteInitializerItemDisplayContext;
import com.liferay.site.admin.web.internal.display.context.comparator.SiteInitializerNameComparator;
import com.liferay.site.initializer.SiteInitializer;
import com.liferay.site.initializer.SiteInitializerRegistry;
import com.liferay.site.util.GroupSearchProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class SiteAdminDisplayContext {
    private String _displayStyle;
    private Group _group;
    private long _groupId;
    private final GroupSearchProvider _groupSearchProvider;
    private String _keywords;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private String _orderByCol;
    private String _orderByType;
    private final HttpServletRequest _request;
    private final SiteInitializerRegistry _siteInitializerRegistry;

    public SiteAdminDisplayContext(HttpServletRequest request, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        this._request = request;
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._siteInitializerRegistry = (SiteInitializerRegistry)request.getAttribute("SITE_INITIALIZER_REGISTRY");
        this._groupSearchProvider = (GroupSearchProvider)request.getAttribute("GROUP_SEARCH_PROVIDER");
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteSites");
                    dropdownItem.setIcon("times-circle");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)SiteAdminDisplayContext.this._request, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public int getChildSitesCount(Group group) {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return GroupLocalServiceUtil.getGroupsCount((long)themeDisplay.getCompanyId(), (long)group.getGroupId(), (boolean)true);
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("orderByCol", this._getOrderByCol());
        clearResultsURL.setParameter("orderByType", this.getOrderByType());
        return clearResultsURL.toString();
    }

    public CreationMenu getCreationMenu() throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        final PortletURL addSiteURL = this._liferayPortletResponse.createRenderURL();
        addSiteURL.setParameter("jspPage", "/select_site_initializer.jsp");
        addSiteURL.setParameter("redirect", themeDisplay.getURLCurrent());
        Group group = this.getGroup();
        if (group != null && this.hasAddChildSitePermission(group)) {
            addSiteURL.setParameter("parentGroupSearchContainerPrimaryKeys", String.valueOf(group.getGroupId()));
        }
        return new CreationMenu(){
            {
                this.addPrimaryDropdownItem(dropdownItem -> {
                    dropdownItem.setHref((Object)addSiteURL.toString());
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)SiteAdminDisplayContext.this._request, (String)"add"));
                });
            }
        };
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this._request);
        this._displayStyle = portalPreferences.getValue("com_liferay_site_admin_web_portlet_SiteAdminPortlet", "display-style", "list");
        return this._displayStyle;
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(SiteAdminDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)SiteAdminDisplayContext.this._request, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(SiteAdminDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)SiteAdminDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public Group getGroup() throws PortalException {
        long groupId = this.getGroupId();
        if (groupId > 0L) {
            this._group = GroupServiceUtil.getGroup((long)groupId);
        }
        return this._group;
    }

    public long getGroupId() {
        if (this._groupId <= 0L) {
            this._groupId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"groupId", (long)0L);
        }
        return this._groupId;
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public int getOrganizationsCount(Group group) {
        LinkedHashMap<String, Long> organizationParams = new LinkedHashMap<String, Long>();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        organizationParams.put("groupOrganization", group.getGroupId());
        organizationParams.put("organizationsGroups", group.getGroupId());
        return OrganizationLocalServiceUtil.searchCount((long)company.getCompanyId(), (long)-1L, null, null, null, null, organizationParams);
    }

    public int getPendingRequestsCount(Group group) {
        int pendingRequests = 0;
        if (group.getType() == 2) {
            pendingRequests = MembershipRequestLocalServiceUtil.searchCount((long)group.getGroupId(), (int)0);
        }
        return pendingRequests;
    }

    public PortletURL getPortletURL() {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("groupId", String.valueOf(this.getGroupId()));
        portletURL.setParameter("displayStyle", this.getDisplayStyle());
        return portletURL;
    }

    public String getSearchActionURL() {
        PortletURL searchTagURL = this.getPortletURL();
        searchTagURL.setParameter("orderByCol", this._getOrderByCol());
        searchTagURL.setParameter("orderByType", this.getOrderByType());
        return searchTagURL.toString();
    }

    public GroupSearch getSearchContainer() throws PortalException {
        return this._groupSearchProvider.getGroupSearch((PortletRequest)this._liferayPortletRequest, this.getPortletURL());
    }

    public List<SiteInitializerItemDisplayContext> getSiteInitializerItems() throws PortalException {
        ArrayList<SiteInitializerItemDisplayContext> siteInitializerItemDisplayContexts = new ArrayList<SiteInitializerItemDisplayContext>();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        List layoutSetPrototypes = LayoutSetPrototypeServiceUtil.search((long)themeDisplay.getCompanyId(), (Boolean)Boolean.TRUE, null);
        for (LayoutSetPrototype layoutSetPrototype : layoutSetPrototypes) {
            siteInitializerItemDisplayContexts.add(new SiteInitializerItemDisplayContext(layoutSetPrototype, themeDisplay.getLocale()));
        }
        List siteInitializers = this._siteInitializerRegistry.getSiteInitializers(themeDisplay.getCompanyId());
        for (SiteInitializer siteInitializer : siteInitializers) {
            SiteInitializerItemDisplayContext siteInitializerItemDisplayContext = new SiteInitializerItemDisplayContext(siteInitializer, themeDisplay.getLocale());
            siteInitializerItemDisplayContexts.add(siteInitializerItemDisplayContext);
        }
        siteInitializerItemDisplayContexts = ListUtil.sort(siteInitializerItemDisplayContexts, (Comparator)((Object)new SiteInitializerNameComparator(true)));
        return siteInitializerItemDisplayContexts;
    }

    public String getSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        sortingURL.setParameter("keywords", this._getKeywords());
        sortingURL.setParameter("orderByCol", this._getOrderByCol());
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public int getTotalItems() throws PortalException {
        GroupSearch groupSearch = this.getSearchContainer();
        return groupSearch.getTotal();
    }

    public int getUserGroupsCount(Group group) {
        LinkedHashMap<String, Long> userGroupParams = new LinkedHashMap<String, Long>();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        userGroupParams.put("userGroupsGroups", group.getGroupId());
        return UserGroupLocalServiceUtil.searchCount((long)company.getCompanyId(), null, userGroupParams);
    }

    public int getUsersCount(Group group) {
        LinkedHashMap<String, Comparable<Boolean>> userParams = new LinkedHashMap<String, Comparable<Boolean>>();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        userParams.put("inherit", Boolean.TRUE);
        userParams.put("usersGroups", Long.valueOf(group.getGroupId()));
        return UserLocalServiceUtil.searchCount((long)company.getCompanyId(), null, (int)0, userParams);
    }

    public List<ViewTypeItem> getViewTypeItems() {
        PortletURL portletURL = this._liferayPortletResponse.createActionURL();
        portletURL.setParameter("javax.portlet.action", "changeDisplayStyle");
        portletURL.setParameter("redirect", PortalUtil.getCurrentURL((HttpServletRequest)this._request));
        return new ViewTypeItemList(portletURL, this.getDisplayStyle()){
            {
                this.addCardViewTypeItem();
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    public boolean hasAddChildSitePermission(Group group) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        return !group.isCompany() && (PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"ADD_COMMUNITY") || GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"ADD_COMMUNITY"));
    }

    public boolean hasDeleteGroupPermission(Group group) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        return !group.isCompany() && GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"DELETE") && !PortalUtil.isSystemGroup((String)group.getGroupKey());
    }

    public boolean hasEditAssignmentsPermission(Group group, boolean organizationUser, boolean userGroupUser) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        return !group.isCompany() && !organizationUser && !userGroupUser && (group.getType() == 1 || group.getType() == 2) && GroupLocalServiceUtil.hasUserGroup((long)user.getUserId(), (long)group.getGroupId()) && !SiteMembershipPolicyUtil.isMembershipRequired((long)user.getUserId(), (long)group.getGroupId());
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref((Object)SiteAdminDisplayContext.this.getPortletURL());
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)SiteAdminDisplayContext.this._request, (String)"all"));
                });
            }
        };
    }

    private String _getKeywords() {
        if (this._keywords == null) {
            this._keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        }
        return this._keywords;
    }

    private String _getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByCol", (String)"name");
        return this._orderByCol;
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref(SiteAdminDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "name"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)SiteAdminDisplayContext.this._request, (String)"name"));
                });
            }
        };
    }
}

