/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.admin.web.internal.portlet;

import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.exception.AssetTagException;
import com.liferay.exportimport.kernel.exception.RemoteExportException;
import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.exception.DuplicateGroupException;
import com.liferay.portal.kernel.exception.GroupFriendlyURLException;
import com.liferay.portal.kernel.exception.GroupInheritContentException;
import com.liferay.portal.kernel.exception.GroupKeyException;
import com.liferay.portal.kernel.exception.GroupParentException;
import com.liferay.portal.kernel.exception.LayoutSetVirtualHostException;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.NoSuchBackgroundTaskException;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.NoSuchLayoutSetException;
import com.liferay.portal.kernel.exception.PendingBackgroundTaskException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RemoteOptionsException;
import com.liferay.portal.kernel.exception.RequiredGroupException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.MembershipRequest;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.RemoteAuthException;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.LayoutSetPrototypeService;
import com.liferay.portal.kernel.service.LayoutSetService;
import com.liferay.portal.kernel.service.MembershipRequestLocalService;
import com.liferay.portal.kernel.service.MembershipRequestService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.TeamLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.servlet.MultiSessionMessages;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.site.util.GroupSearchProvider;
import com.liferay.site.util.GroupURLProvider;
import com.liferay.sites.kernel.util.SitesUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.css-class-wrapper=portlet-site-admin", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.icon=/icons/site_admin.png", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=Sites Admin", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.template-path=/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_site_admin_web_portlet_SiteAdminPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class SiteAdminPortlet
extends MVCPortlet {
    @Reference
    protected BackgroundTaskManager backgroundTaskManager;
    protected GroupLocalService groupLocalService;
    protected GroupSearchProvider groupSearchProvider;
    protected GroupService groupService;
    protected GroupURLProvider groupURLProvider;
    @Reference
    protected Http http;
    protected LayoutLocalService layoutLocalService;
    protected LayoutSetLocalService layoutSetLocalService;
    protected LayoutSetPrototypeService layoutSetPrototypeService;
    protected LayoutSetService layoutSetService;
    protected MembershipRequestLocalService membershipRequestLocalService;
    protected MembershipRequestService membershipRequestService;
    @Reference
    protected Portal portal;
    protected RoleLocalService roleLocalService;
    @Reference
    protected Staging staging;
    protected TeamLocalService teamLocalService;
    protected UserLocalService userLocalService;
    protected UserService userService;
    private static final int _LAYOUT_SET_VISIBILITY_PRIVATE = 1;
    private static final Log _log = LogFactoryUtil.getLog(SiteAdminPortlet.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);

    public void activate(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.updateActive(actionRequest, true);
    }

    public void changeDisplayStyle(ActionRequest actionRequest, ActionResponse actionResponse) {
        this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        String displayStyle = ParamUtil.getString((PortletRequest)actionRequest, (String)"displayStyle");
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)actionRequest);
        portalPreferences.setValue("com_liferay_site_admin_web_portlet_SiteAdminPortlet", "display-style", displayStyle);
    }

    public void deactivate(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.updateActive(actionRequest, false);
    }

    public void deleteBackgroundTask(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long backgroundTaskId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"backgroundTaskId");
        this.backgroundTaskManager.deleteBackgroundTask(backgroundTaskId);
    }

    public void deleteGroups(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] deleteGroupIds = null;
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        deleteGroupIds = groupId > 0L ? new long[]{groupId} : ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds");
        for (long deleteGroupId : deleteGroupIds) {
            this.groupService.deleteGroup(deleteGroupId);
            LiveUsers.deleteGroup((long)themeDisplay.getCompanyId(), (long)deleteGroupId);
        }
    }

    public void editGroup(ActionRequest actionRequest, ActionResponse actionResponse) throws Throwable {
        GroupCallable groupCallable = new GroupCallable(actionRequest);
        Group group = (Group)TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, (Callable)groupCallable);
        long liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
        if (liveGroupId <= 0L) {
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
            MultiSessionMessages.add((PortletRequest)actionRequest, (String)"com_liferay_site_admin_web_portlet_SiteSettingsPortletrequestProcessed");
        }
        PortletURL siteAdministrationURL = this.getSiteAdministrationURL(actionRequest, group);
        siteAdministrationURL.setParameter("historyKey", this.getHistoryKey(actionRequest, actionResponse));
        siteAdministrationURL.setParameter("redirect", siteAdministrationURL.toString());
        actionRequest.setAttribute("REDIRECT", (Object)siteAdministrationURL.toString());
        this.sendRedirect(actionRequest, actionResponse);
    }

    public void editGroupAssignments(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        long[] removeUserIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"removeUserIds"), (long)0L);
        removeUserIds = this.filterRemoveUserIds(groupId, removeUserIds);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        this.userService.unsetGroupUsers(groupId, removeUserIds, serviceContext);
        LiveUsers.leaveGroup((long)themeDisplay.getCompanyId(), (long)groupId, (long[])removeUserIds);
    }

    public void resetMergeFailCountAndMerge(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long layoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutSetPrototypeId");
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypeService.getLayoutSetPrototype(layoutSetPrototypeId);
        SitesUtil.setMergeFailCount((LayoutSetPrototype)layoutSetPrototype, (int)0);
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        boolean privateLayoutSet = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayoutSet");
        LayoutSet layoutSet = this.layoutSetLocalService.getLayoutSet(groupId, privateLayoutSet);
        SitesUtil.resetPrototype((LayoutSet)layoutSet);
        Group group = this.groupLocalService.getGroup(groupId);
        SitesUtil.mergeLayoutSetPrototypeLayouts((Group)group, (LayoutSet)layoutSet);
        layoutSetPrototype = this.layoutSetPrototypeService.getLayoutSetPrototype(layoutSetPrototypeId);
        if (SitesUtil.getMergeFailCount((LayoutSetPrototype)layoutSetPrototype) > 0) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"resetMergeFailCountAndMerge");
        }
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        renderRequest.setAttribute("GROUP_SEARCH_PROVIDER", (Object)this.groupSearchProvider);
        renderRequest.setAttribute("GROUP_URL_PROVIDER", (Object)this.groupURLProvider);
        if (SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchBackgroundTaskException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchGroupException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (Class[])PrincipalException.getNestedClasses())) {
            this.include("/error.jsp", renderRequest, renderResponse);
        } else if (SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchLayoutSetException.class.getName())) {
            this.include("/view.jsp", renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected long[] filterRemoveUserIds(long groupId, long[] userIds) throws Exception {
        HashSet<Long> filteredUserIds = new HashSet<Long>(userIds.length);
        for (long userId : userIds) {
            if (!this.userLocalService.hasGroupUser(groupId, userId)) continue;
            filteredUserIds.add(userId);
        }
        return ArrayUtil.toArray((Long[])filteredUserIds.toArray(new Long[filteredUserIds.size()]));
    }

    protected String getHistoryKey(ActionRequest actionRequest, ActionResponse actionResponse) {
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        return this.http.getParameter(redirect, actionResponse.getNamespace() + "historyKey", false);
    }

    protected Group getLiveGroup(PortletRequest portletRequest) throws PortalException {
        long liveGroupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"liveGroupId");
        if (liveGroupId > 0L) {
            return this.groupLocalService.getGroup(liveGroupId);
        }
        return null;
    }

    protected long getRefererGroupId(ThemeDisplay themeDisplay) throws Exception {
        long refererGroupId;
        block2: {
            refererGroupId = 0L;
            try {
                Layout refererLayout = this.layoutLocalService.getLayout(themeDisplay.getRefererPlid());
                refererGroupId = refererLayout.getGroupId();
            }
            catch (NoSuchLayoutException nsle) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)nsle, (Throwable)nsle);
            }
        }
        return refererGroupId;
    }

    protected List<Role> getRoles(PortletRequest portletRequest) throws Exception {
        long[] siteRolesRoleIds;
        ArrayList<Role> roles = new ArrayList<Role>();
        for (long siteRolesRoleId : siteRolesRoleIds = ArrayUtil.unique((long[])ParamUtil.getLongValues((PortletRequest)portletRequest, (String)"siteRolesSearchContainerPrimaryKeys"))) {
            if (siteRolesRoleId == 0L) continue;
            Role role = this.roleLocalService.getRole(siteRolesRoleId);
            roles.add(role);
        }
        return roles;
    }

    protected PortletURL getSiteAdministrationURL(ActionRequest actionRequest, Group group) {
        String portletId = "com_liferay_site_admin_web_portlet_SiteAdminPortlet";
        long liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
        if (liveGroupId <= 0L) {
            portletId = "com_liferay_site_admin_web_portlet_SiteSettingsPortlet";
        }
        return this.portal.getControlPanelPortletURL((PortletRequest)actionRequest, group, portletId, 0L, 0L, "RENDER_PHASE");
    }

    protected List<Team> getTeams(PortletRequest portletRequest) throws Exception {
        long[] teamsTeamIds;
        ArrayList<Team> teams = new ArrayList<Team>();
        for (long teamsTeamId : teamsTeamIds = ArrayUtil.unique((long[])ParamUtil.getLongValues((PortletRequest)portletRequest, (String)"teamsSearchContainerPrimaryKeys"))) {
            if (teamsTeamId == 0L) continue;
            Team team = this.teamLocalService.getTeam(teamsTeamId);
            teams.add(team);
        }
        return teams;
    }

    protected boolean isSessionErrorException(Throwable cause) {
        return cause instanceof AssetCategoryException || cause instanceof AssetTagException || cause instanceof AuthException || cause instanceof DuplicateGroupException || cause instanceof GroupFriendlyURLException || cause instanceof GroupInheritContentException || cause instanceof GroupKeyException || cause instanceof GroupParentException || cause instanceof LayoutSetVirtualHostException || cause instanceof LocaleException || cause instanceof NoSuchBackgroundTaskException || cause instanceof NoSuchLayoutSetException || cause instanceof PendingBackgroundTaskException || cause instanceof RemoteAuthException || cause instanceof RemoteExportException || cause instanceof RemoteOptionsException || cause instanceof RequiredGroupException || cause instanceof SystemException || super.isSessionErrorException(cause);
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupSearchProvider(GroupSearchProvider groupSearchProvider) {
        this.groupSearchProvider = groupSearchProvider;
    }

    @Reference(unbind="-")
    protected void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    @Reference(unbind="-")
    protected void setGroupURLProvider(GroupURLProvider groupURLProvider) {
        this.groupURLProvider = groupURLProvider;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this.layoutLocalService = layoutLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutSetLocalService(LayoutSetLocalService layoutSetLocalService) {
        this.layoutSetLocalService = layoutSetLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutSetPrototypeService(LayoutSetPrototypeService layoutSetPrototypeService) {
        this.layoutSetPrototypeService = layoutSetPrototypeService;
    }

    @Reference(unbind="-")
    protected void setLayoutSetService(LayoutSetService layoutSetService) {
        this.layoutSetService = layoutSetService;
    }

    @Reference(unbind="-")
    protected void setMembershipRequestLocalService(MembershipRequestLocalService membershipRequestLocalService) {
        this.membershipRequestLocalService = membershipRequestLocalService;
    }

    @Reference(unbind="-")
    protected void setMembershipRequestService(MembershipRequestService membershipRequestService) {
        this.membershipRequestService = membershipRequestService;
    }

    @Reference(unbind="-")
    protected void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    @Reference(unbind="-")
    protected void setTeamLocalService(TeamLocalService teamLocalService) {
        this.teamLocalService = teamLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this.userLocalService = userLocalService;
    }

    @Reference(unbind="-")
    protected void setUserService(UserService userService) {
        this.userService = userService;
    }

    protected void updateActive(ActionRequest actionRequest, boolean active) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        if (groupId == themeDisplay.getDoAsGroupId() || groupId == themeDisplay.getScopeGroupId() || groupId == this.getRefererGroupId(themeDisplay)) {
            throw new RequiredGroupException.MustNotDeleteCurrentGroup(groupId);
        }
        Group group = this.groupService.getGroup(groupId);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Group.class.getName(), (PortletRequest)actionRequest);
        this.groupService.updateGroup(groupId, group.getParentGroupId(), group.getNameMap(), group.getDescriptionMap(), group.getType(), group.isManualMembership(), group.getMembershipRestriction(), group.getFriendlyURL(), group.isInheritContent(), active, serviceContext);
        themeDisplay.setScopeGroupId(groupId);
    }

    protected Group updateGroup(ActionRequest actionRequest) throws Exception {
        String[] analyticsTypes;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long userId = this.portal.getUserId((PortletRequest)actionRequest);
        long liveGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"liveGroupId");
        long parentGroupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentGroupSearchContainerPrimaryKeys", (long)0L);
        Map nameMap = null;
        Map descriptionMap = null;
        int type = 0;
        String friendlyURL = null;
        boolean inheritContent = false;
        boolean active = false;
        boolean manualMembership = true;
        int membershipRestriction = 0;
        boolean actionRequestMembershipRestriction = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"membershipRestriction");
        if (actionRequestMembershipRestriction && parentGroupId != 0L) {
            membershipRestriction = 1;
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)Group.class.getName(), (PortletRequest)actionRequest);
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        Group liveGroup = null;
        if (liveGroupId <= 0L) {
            nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
            descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
            type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type");
            friendlyURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"friendlyURL");
            manualMembership = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"manualMembership");
            inheritContent = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"inheritContent");
            active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active");
            liveGroup = this.groupService.addGroup(parentGroupId, 0L, nameMap, descriptionMap, type, manualMembership, membershipRestriction, friendlyURL, true, inheritContent, active, serviceContext);
            LiveUsers.joinGroup((long)themeDisplay.getCompanyId(), (long)liveGroup.getGroupId(), (long)userId);
        } else {
            liveGroup = this.groupLocalService.getGroup(liveGroupId);
            nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name", (Map)liveGroup.getNameMap());
            descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description", (Map)liveGroup.getDescriptionMap());
            type = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"type", (int)liveGroup.getType());
            manualMembership = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"manualMembership", (boolean)liveGroup.isManualMembership());
            friendlyURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"friendlyURL", (String)liveGroup.getFriendlyURL());
            inheritContent = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"inheritContent", (boolean)liveGroup.getInheritContent());
            active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active", (boolean)liveGroup.getActive());
            liveGroup = this.groupService.updateGroup(liveGroupId, parentGroupId, nameMap, descriptionMap, type, manualMembership, membershipRestriction, friendlyURL, inheritContent, active, serviceContext);
            if (type == 1) {
                List membershipRequests = this.membershipRequestLocalService.search(liveGroupId, 0, -1, -1);
                for (MembershipRequest membershipRequest : membershipRequests) {
                    this.membershipRequestService.updateStatus(membershipRequest.getMembershipRequestId(), themeDisplay.translate("your-membership-has-been-approved"), 1L, serviceContext);
                    LiveUsers.joinGroup((long)themeDisplay.getCompanyId(), (long)membershipRequest.getGroupId(), (long[])new long[]{membershipRequest.getUserId()});
                }
            }
        }
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        String customJspServletContextName = ParamUtil.getString((PortletRequest)actionRequest, (String)"customJspServletContextName", (String)typeSettingsProperties.getProperty("customJspServletContextName"));
        typeSettingsProperties.setProperty("customJspServletContextName", customJspServletContextName);
        typeSettingsProperties.setProperty("defaultSiteRoleIds", ListUtil.toString(this.getRoles((PortletRequest)actionRequest), (Accessor)Role.ROLE_ID_ACCESSOR, (String)","));
        typeSettingsProperties.setProperty("defaultTeamIds", ListUtil.toString(this.getTeams((PortletRequest)actionRequest), (Accessor)Team.TEAM_ID_ACCESSOR, (String)","));
        for (String analyticsType : analyticsTypes = PrefsPropsUtil.getStringArray((long)themeDisplay.getCompanyId(), (String)"admin.analytics.types", (String)"\n")) {
            if (StringUtil.equalsIgnoreCase((String)analyticsType, (String)"google")) {
                String googleAnalyticsId = ParamUtil.getString((PortletRequest)actionRequest, (String)"googleAnalyticsId", (String)typeSettingsProperties.getProperty("googleAnalyticsId"));
                typeSettingsProperties.setProperty("googleAnalyticsId", googleAnalyticsId);
                continue;
            }
            String analyticsScript = ParamUtil.getString((PortletRequest)actionRequest, (String)("analytics_" + analyticsType), (String)typeSettingsProperties.getProperty(analyticsType));
            typeSettingsProperties.setProperty("analytics_" + analyticsType, analyticsScript);
        }
        boolean trashEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"trashEnabled", (boolean)GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("trashEnabled"), (boolean)true));
        typeSettingsProperties.setProperty("trashEnabled", String.valueOf(trashEnabled));
        int trashEntriesMaxAgeCompany = PrefsPropsUtil.getInteger((long)themeDisplay.getCompanyId(), (String)"trash.entries.max.age");
        int trashEntriesMaxAgeGroup = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"trashEntriesMaxAge");
        if (trashEntriesMaxAgeGroup <= 0) {
            trashEntriesMaxAgeGroup = GetterUtil.getInteger((String)typeSettingsProperties.getProperty("trashEntriesMaxAge"), (int)trashEntriesMaxAgeCompany);
        }
        if (trashEntriesMaxAgeGroup != trashEntriesMaxAgeCompany) {
            typeSettingsProperties.setProperty("trashEntriesMaxAge", String.valueOf(GetterUtil.getInteger((Object)trashEntriesMaxAgeGroup)));
        } else {
            typeSettingsProperties.remove((Object)"trashEntriesMaxAge");
        }
        int contentSharingWithChildrenEnabled = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"contentSharingWithChildrenEnabled", (int)GetterUtil.getInteger((String)typeSettingsProperties.getProperty("contentSharingWithChildrenEnabled"), (int)-1));
        typeSettingsProperties.setProperty("contentSharingWithChildrenEnabled", String.valueOf(contentSharingWithChildrenEnabled));
        UnicodeProperties formTypeSettingsProperties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"TypeSettingsProperties--");
        typeSettingsProperties.putAll((Map)formTypeSettingsProperties);
        LayoutSet publicLayoutSet = liveGroup.getPublicLayoutSet();
        String publicVirtualHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"publicVirtualHost", (String)publicLayoutSet.getVirtualHostname());
        this.layoutSetService.updateVirtualHost(liveGroup.getGroupId(), false, publicVirtualHost);
        LayoutSet privateLayoutSet = liveGroup.getPrivateLayoutSet();
        String privateVirtualHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"privateVirtualHost", (String)privateLayoutSet.getVirtualHostname());
        this.layoutSetService.updateVirtualHost(liveGroup.getGroupId(), true, privateVirtualHost);
        if (liveGroup.hasStagingGroup()) {
            Group stagingGroup = liveGroup.getStagingGroup();
            friendlyURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"stagingFriendlyURL", (String)stagingGroup.getFriendlyURL());
            this.groupService.updateFriendlyURL(stagingGroup.getGroupId(), friendlyURL);
            LayoutSet stagingPublicLayoutSet = stagingGroup.getPublicLayoutSet();
            publicVirtualHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"stagingPublicVirtualHost", (String)stagingPublicLayoutSet.getVirtualHostname());
            this.layoutSetService.updateVirtualHost(stagingGroup.getGroupId(), false, publicVirtualHost);
            LayoutSet stagingPrivateLayoutSet = stagingGroup.getPrivateLayoutSet();
            privateVirtualHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"stagingPrivateVirtualHost", (String)stagingPrivateLayoutSet.getVirtualHostname());
            this.layoutSetService.updateVirtualHost(stagingGroup.getGroupId(), true, privateVirtualHost);
            UnicodeProperties stagedGroupTypeSettingsProperties = stagingGroup.getTypeSettingsProperties();
            stagedGroupTypeSettingsProperties.putAll((Map)formTypeSettingsProperties);
            this.groupService.updateGroup(stagingGroup.getGroupId(), stagedGroupTypeSettingsProperties.toString());
        }
        liveGroup = this.groupService.updateGroup(liveGroup.getGroupId(), typeSettingsProperties.toString());
        long privateLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"privateLayoutSetPrototypeId");
        long publicLayoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"publicLayoutSetPrototypeId");
        boolean privateLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayoutSetPrototypeLinkEnabled", (boolean)privateLayoutSet.isLayoutSetPrototypeLinkEnabled());
        boolean publicLayoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"publicLayoutSetPrototypeLinkEnabled", (boolean)publicLayoutSet.isLayoutSetPrototypeLinkEnabled());
        if (privateLayoutSetPrototypeId == 0L && publicLayoutSetPrototypeId == 0L && !privateLayoutSetPrototypeLinkEnabled && !publicLayoutSetPrototypeLinkEnabled) {
            long layoutSetPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutSetPrototypeId");
            int layoutSetVisibility = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"layoutSetVisibility");
            boolean layoutSetPrototypeLinkEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"layoutSetPrototypeLinkEnabled", (layoutSetPrototypeId > 0L ? 1 : 0) != 0);
            if (layoutSetVisibility == 1) {
                privateLayoutSetPrototypeId = layoutSetPrototypeId;
                privateLayoutSetPrototypeLinkEnabled = layoutSetPrototypeLinkEnabled;
            } else {
                publicLayoutSetPrototypeId = layoutSetPrototypeId;
                publicLayoutSetPrototypeLinkEnabled = layoutSetPrototypeLinkEnabled;
            }
        }
        if (!liveGroup.isStaged() || liveGroup.isStagedRemotely()) {
            SitesUtil.updateLayoutSetPrototypesLinks((Group)liveGroup, (long)publicLayoutSetPrototypeId, (long)privateLayoutSetPrototypeId, (boolean)publicLayoutSetPrototypeLinkEnabled, (boolean)privateLayoutSetPrototypeLinkEnabled);
        } else {
            SitesUtil.updateLayoutSetPrototypesLinks((Group)liveGroup.getStagingGroup(), (long)publicLayoutSetPrototypeId, (long)privateLayoutSetPrototypeId, (boolean)publicLayoutSetPrototypeLinkEnabled, (boolean)privateLayoutSetPrototypeLinkEnabled);
        }
        themeDisplay.setSiteGroupId(liveGroup.getGroupId());
        return liveGroup;
    }

    private class GroupCallable
    implements Callable<Group> {
        private final ActionRequest _actionRequest;

        @Override
        public Group call() throws Exception {
            return SiteAdminPortlet.this.updateGroup(this._actionRequest);
        }

        private GroupCallable(ActionRequest actionRequest) {
            this._actionRequest = actionRequest;
        }
    }
}

