/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.admin.web.internal.display.context;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupServiceUtil;
import com.liferay.portal.kernel.service.MembershipRequestLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.usersadmin.search.GroupSearch;
import com.liferay.site.util.GroupSearchProvider;
import java.util.LinkedHashMap;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class SiteAdminDisplayContext {
    private String _displayStyle;
    private Group _group;
    private long _groupId;
    private final GroupSearchProvider _groupSearchProvider;
    private String _keywords;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final HttpServletRequest _request;

    public SiteAdminDisplayContext(HttpServletRequest request, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws PortalException {
        this._request = request;
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._groupSearchProvider = (GroupSearchProvider)request.getAttribute("GROUP_SEARCH_PROVIDER");
    }

    public int getChildSitesCount(Group group) {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return GroupLocalServiceUtil.getGroupsCount((long)themeDisplay.getCompanyId(), (long)group.getGroupId(), (boolean)true);
    }

    public PortletURL getCurrentURL() {
        PortletURL currentURL = PortletURLUtil.getCurrent((LiferayPortletRequest)this._liferayPortletRequest, (LiferayPortletResponse)this._liferayPortletResponse);
        currentURL.setParameter("displayStyle", this.getDisplayStyle());
        return currentURL;
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this._request);
        this._displayStyle = portalPreferences.getValue("com_liferay_site_admin_web_portlet_SiteAdminPortlet", "display-style", "list");
        return this._displayStyle;
    }

    public Group getGroup() throws PortalException {
        long groupId = this.getGroupId();
        if (groupId > 0L) {
            this._group = GroupServiceUtil.getGroup((long)groupId);
        }
        return this._group;
    }

    public long getGroupId() {
        if (this._groupId <= 0L) {
            this._groupId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"groupId", (long)0L);
        }
        return this._groupId;
    }

    public String getKeywords() {
        if (this._keywords == null) {
            this._keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        }
        return this._keywords;
    }

    public int getOrganizationsCount() throws PortalException {
        return this.getOrganizationsCount(this.getGroup());
    }

    public int getOrganizationsCount(Group group) {
        LinkedHashMap<String, Long> organizationParams = new LinkedHashMap<String, Long>();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        organizationParams.put("groupOrganization", group.getGroupId());
        organizationParams.put("organizationsGroups", group.getGroupId());
        return OrganizationLocalServiceUtil.searchCount((long)company.getCompanyId(), (long)-1L, null, null, null, null, organizationParams);
    }

    public int getPendingRequestsCount() throws PortalException {
        return this.getPendingRequestsCount(this.getGroup());
    }

    public int getPendingRequestsCount(Group group) throws PortalException {
        int pendingRequests = 0;
        if (group.getType() == 2) {
            pendingRequests = MembershipRequestLocalServiceUtil.searchCount((long)group.getGroupId(), (int)0);
        }
        return pendingRequests;
    }

    public PortletURL getPortletURL() throws PortalException {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("groupId", String.valueOf(this.getGroupId()));
        portletURL.setParameter("displayStyle", this.getDisplayStyle());
        return portletURL;
    }

    public GroupSearch getSearchContainer() throws PortalException {
        return this._groupSearchProvider.getGroupSearch((PortletRequest)this._liferayPortletRequest, this.getPortletURL());
    }

    public PortletURL getSearchURL() throws PortalException {
        PortletURL searchURL = this._liferayPortletResponse.createRenderURL();
        searchURL.setParameter("groupId", String.valueOf(this.getGroupId()));
        searchURL.setParameter("displayStyle", this.getDisplayStyle());
        return searchURL;
    }

    public int getUserGroupsCount(Group group) {
        LinkedHashMap<String, Long> userGroupParams = new LinkedHashMap<String, Long>();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        userGroupParams.put("userGroupsGroups", group.getGroupId());
        return UserGroupLocalServiceUtil.searchCount((long)company.getCompanyId(), null, userGroupParams);
    }

    public int getUsersCount(Group group) {
        LinkedHashMap<String, Comparable<Boolean>> userParams = new LinkedHashMap<String, Comparable<Boolean>>();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Company company = themeDisplay.getCompany();
        userParams.put("inherit", Boolean.TRUE);
        userParams.put("usersGroups", Long.valueOf(group.getGroupId()));
        return UserLocalServiceUtil.searchCount((long)company.getCompanyId(), null, (int)0, userParams);
    }

    public boolean hasAddChildSitePermission(Group group) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        return !group.isCompany() && (PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"ADD_COMMUNITY") || GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"ADD_COMMUNITY"));
    }

    public boolean hasDeleteGroupPermission(Group group) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        return !group.isCompany() && GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"DELETE") && !PortalUtil.isSystemGroup((String)group.getGroupKey());
    }

    public boolean hasEditAssignmentsPermission(Group group, boolean organizationUser, boolean userGroupUser) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        return !group.isCompany() && !organizationUser && !userGroupUser && (group.getType() == 1 || group.getType() == 2) && GroupLocalServiceUtil.hasUserGroup((long)user.getUserId(), (long)group.getGroupId()) && !SiteMembershipPolicyUtil.isMembershipRequired((long)user.getUserId(), (long)group.getGroupId());
    }
}

