/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.shrinkwrap.osgi.impl;

import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.build.Workspace;
import aQute.bnd.osgi.Processor;
import com.liferay.shrinkwrap.osgi.api.BndArchive;
import com.liferay.shrinkwrap.osgi.api.BndProjectBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;

public class BndProjectBuilderImpl
implements BndProjectBuilder {
    private File _baseDir;
    private File _bndFile;
    private final Collection<File> _classPathFiles = new ArrayList<File>();
    private boolean _generateManifest = true;
    private File _projectDir;
    private final List<File> _projectPropertiesFiles = new ArrayList<File>();
    private File _workspaceDir;
    private final List<File> _workspacePropertiesFiles = new ArrayList<File>();

    public BndProjectBuilderImpl(Archive<?> archive) {
    }

    @Override
    public BndProjectBuilder addClassPath(File classPathFile) {
        this._classPathFiles.add(classPathFile);
        return this;
    }

    @Override
    public BndProjectBuilder addProjectPropertiesFile(File projectPropertiesFile) {
        this._projectPropertiesFiles.add(projectPropertiesFile);
        return this;
    }

    @Override
    public BndProjectBuilder addWorkspacePropertiesFile(File workspacePropertiesFile) {
        this._workspacePropertiesFiles.add(workspacePropertiesFile);
        return this;
    }

    public <TYPE extends Assignable> TYPE as(Class<TYPE> typeClass) {
        try {
            BndArchive bndArchive = this.asBndJar();
            return bndArchive.as(typeClass);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public BndArchive asBndJar() {
        try {
            Workspace workspace = new Workspace(this._workspaceDir);
            Properties workspaceProperties = this.buildProperties((Processor)workspace, null, this._workspacePropertiesFiles.toArray(new File[0]));
            workspace.setProperties(workspaceProperties);
            Project project = new Project(workspace, this._projectDir);
            Properties projectProperties = this.buildProperties((Processor)project, this._bndFile, this._projectPropertiesFiles.toArray(new File[0]));
            project.setProperties(projectProperties);
            ProjectBuilder projectBuilder = new ProjectBuilder(project);
            projectBuilder.setBase(this._baseDir);
            for (File classPathFile : this._classPathFiles) {
                projectBuilder.addClasspath(classPathFile);
            }
            if (!this._generateManifest) {
                projectBuilder.setProperty("-nomanifest", "true");
            }
            return new BndArchive(projectBuilder.build());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public BndProjectBuilder generateManifest(boolean generateManifest) {
        this._generateManifest = generateManifest;
        return this;
    }

    @Override
    public BndProjectBuilder setBaseDir(File baseDir) {
        this._baseDir = baseDir;
        if (this._projectDir == null) {
            this.setProjectDir(baseDir);
        }
        if (this._workspaceDir == null) {
            this.setWorkspaceDir(baseDir);
        }
        return this;
    }

    @Override
    public BndProjectBuilder setBndFile(File bndFile) {
        this._bndFile = bndFile;
        File absoluteBndFile = bndFile.getAbsoluteFile();
        File parentBndDir = absoluteBndFile.getParentFile();
        if (this._baseDir == null) {
            this.setBaseDir(parentBndDir);
        }
        if (this._projectDir == null) {
            this.setProjectDir(parentBndDir);
        }
        if (this._workspaceDir == null) {
            this.setWorkspaceDir(parentBndDir);
        }
        return this;
    }

    @Override
    public BndProjectBuilder setProjectDir(File projectDir) {
        if (this._workspaceDir == null) {
            this.setWorkspaceDir(projectDir);
        }
        this._projectDir = projectDir;
        return this;
    }

    @Override
    public BndProjectBuilder setWorkspaceDir(File workspaceDir) {
        this._workspaceDir = workspaceDir;
        return this;
    }

    protected Properties buildProperties(Processor processor, File propertiesFile, File ... extraFiles) throws IOException {
        Properties properties = new Properties();
        for (File extraFile : extraFiles) {
            properties.putAll((Map<?, ?>)processor.loadProperties(extraFile));
        }
        if (propertiesFile != null) {
            properties.putAll((Map<?, ?>)processor.loadProperties(propertiesFile));
        }
        return properties;
    }
}

