/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.notifications.internal.notifications;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.notifications.BaseModelUserNotificationHandler;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.sharing.model.SharingEntry;
import com.liferay.sharing.service.SharingEntryLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_sharing_web_portlet_SharingPortlet"}, service={UserNotificationHandler.class})
public class SharingUserNotificationHandler
extends BaseModelUserNotificationHandler {
    @Reference
    private SharingEntryLocalService _sharingEntryLocalService;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public SharingUserNotificationHandler() {
        this.setPortletId("com_liferay_sharing_web_portlet_SharingPortlet");
    }

    protected String getBody(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        JSONObject userNotificationEventPayloadJSONObject = JSONFactoryUtil.createJSONObject((String)userNotificationEvent.getPayload());
        SharingEntry sharingEntry = this._sharingEntryLocalService.fetchSharingEntry(userNotificationEventPayloadJSONObject.getLong("classPK"));
        if (sharingEntry == null) {
            this._userNotificationEventLocalService.deleteUserNotificationEvent(userNotificationEvent.getUserNotificationEventId());
            return null;
        }
        AssetRenderer assetRenderer = this.getAssetRenderer(sharingEntry.getClassName(), sharingEntry.getClassPK());
        if (assetRenderer == null || this._isInTrash(sharingEntry.getClassName(), sharingEntry.getClassPK())) {
            this._userNotificationEventLocalService.deleteUserNotificationEvent(userNotificationEvent.getUserNotificationEventId());
            return null;
        }
        String message = userNotificationEventPayloadJSONObject.getString("message");
        if (Validator.isNull((String)message)) {
            this._userNotificationEventLocalService.deleteUserNotificationEvent(userNotificationEvent);
        }
        return message;
    }

    private boolean _isInTrash(String className, long classPK) throws PortalException {
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        if (trashHandler == null) {
            return false;
        }
        return trashHandler.isInTrash(classPK);
    }
}

