/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.blogs.internal.security.permission;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.sharing.security.permission.SharingEntryAction;
import com.liferay.sharing.security.permission.SharingPermissionChecker;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.blogs.model.BlogsEntry"}, service={SharingPermissionChecker.class})
public class BlogsEntrySharingPermissionChecker
implements SharingPermissionChecker {
    private static final Set<SharingEntryAction> _actionKeysSet = new HashSet<SharingEntryAction>(Arrays.asList(SharingEntryAction.ADD_DISCUSSION, SharingEntryAction.UPDATE, SharingEntryAction.VIEW));
    @Reference(target="(model.class.name=com.liferay.blogs.model.BlogsEntry)")
    private ModelResourcePermission<BlogsEntry> _blogsEntryModelResourcePermission;

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, long groupId, Collection<SharingEntryAction> sharingEntryActions) throws PortalException {
        for (SharingEntryAction sharingEntryAction : sharingEntryActions) {
            if (!_actionKeysSet.contains(sharingEntryAction)) {
                return false;
            }
            if (this._blogsEntryModelResourcePermission.contains(permissionChecker, classPK, sharingEntryAction.getActionId())) continue;
            return false;
        }
        return true;
    }
}

