/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.soap.repository.search;

import com.liferay.document.library.repository.external.ExtRepositoryObjectType;
import com.liferay.document.library.repository.external.search.ExtRepositoryQueryMapper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.QueryTerm;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermRangeQuery;
import com.liferay.portal.kernel.search.WildcardQuery;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.sharepoint.soap.repository.SharepointWSRepository;
import com.liferay.sharepoint.soap.repository.connector.SharepointConnection;
import com.liferay.sharepoint.soap.repository.connector.SharepointConnectionInfo;
import com.liferay.sharepoint.soap.repository.connector.SharepointObject;
import com.liferay.sharepoint.soap.repository.connector.schema.query.Query;
import com.liferay.sharepoint.soap.repository.connector.schema.query.QueryClause;
import com.liferay.sharepoint.soap.repository.connector.schema.query.QueryField;
import com.liferay.sharepoint.soap.repository.connector.schema.query.QueryOptionsList;
import com.liferay.sharepoint.soap.repository.connector.schema.query.QueryValue;
import com.liferay.sharepoint.soap.repository.connector.schema.query.join.AndJoin;
import com.liferay.sharepoint.soap.repository.connector.schema.query.join.BaseJoin;
import com.liferay.sharepoint.soap.repository.connector.schema.query.join.OrJoin;
import com.liferay.sharepoint.soap.repository.connector.schema.query.operator.BaseMultiValueOperator;
import com.liferay.sharepoint.soap.repository.connector.schema.query.operator.BaseNoValueOperator;
import com.liferay.sharepoint.soap.repository.connector.schema.query.operator.BaseSingleValueOperator;
import com.liferay.sharepoint.soap.repository.connector.schema.query.operator.BeginsWithOperator;
import com.liferay.sharepoint.soap.repository.connector.schema.query.operator.ContainsOperator;
import com.liferay.sharepoint.soap.repository.connector.schema.query.operator.EqOperator;
import com.liferay.sharepoint.soap.repository.connector.schema.query.operator.GeqOperator;
import com.liferay.sharepoint.soap.repository.connector.schema.query.operator.GtOperator;
import com.liferay.sharepoint.soap.repository.connector.schema.query.operator.IncludesOperator;
import com.liferay.sharepoint.soap.repository.connector.schema.query.operator.IsNotNullOperator;
import com.liferay.sharepoint.soap.repository.connector.schema.query.operator.IsNullOperator;
import com.liferay.sharepoint.soap.repository.connector.schema.query.operator.LeqOperator;
import com.liferay.sharepoint.soap.repository.connector.schema.query.operator.LtOperator;
import com.liferay.sharepoint.soap.repository.connector.schema.query.operator.NeqOperator;
import com.liferay.sharepoint.soap.repository.connector.schema.query.operator.NotIncludesOperator;
import com.liferay.sharepoint.soap.repository.connector.schema.query.option.BaseQueryOption;
import com.liferay.sharepoint.soap.repository.connector.schema.query.option.FolderQueryOption;
import com.liferay.sharepoint.soap.repository.connector.schema.query.option.ViewAttributesQueryOption;
import com.liferay.sharepoint.soap.repository.model.SharepointWSFolder;
import com.liferay.sharepoint.soap.repository.search.LiferayQueryExplainer;
import com.liferay.sharepoint.soap.repository.search.SharepointQueryOperator;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SharepointQueryBuilder {
    private static final String _SHAREPOINT_DATE_FORMAT_PATTERN = "yyyy-MM-dd' 'HH:mm:ss";
    private static final Log _log = LogFactoryUtil.getLog(SharepointQueryBuilder.class);
    private static final LiferayQueryExplainer _liferayQueryExplainer = new LiferayQueryExplainer();
    private static final Map<String, String> _sharepointFields = HashMapBuilder.put((Object)"createDate", (Object)"Created_x0020_Date").put((Object)"folderId", (Object)"FileDirRef").put((Object)"modified", (Object)"Modified").put((Object)"name", (Object)"FileLeafRef").put((Object)"title", (Object)"FileLeafRef").put((Object)"userId", (Object)"Modified_x0020_By").put((Object)"userName", (Object)"Modified_x0020_By").build();
    private static final Set<String> _supportedFields = new HashSet<String>(Arrays.asList("createDate", "folderId", "modified", "name", "title", "userId", "userName"));
    private final ExtRepositoryQueryMapper _extRepositoryQueryMapper;
    private final Query _query;
    private final QueryOptionsList _queryOptionsList;
    private final SharepointConnectionInfo _sharepointConnectionInfo;
    private final SharepointWSRepository _sharepointWSRepository;

    public SharepointQueryBuilder(SharepointWSRepository sharepointWSRepository, SearchContext searchContext, com.liferay.portal.kernel.search.Query query, ExtRepositoryQueryMapper extRepositoryQueryMapper) throws PortalException {
        this._sharepointWSRepository = sharepointWSRepository;
        this._extRepositoryQueryMapper = extRepositoryQueryMapper;
        SharepointConnection sharepointConnection = sharepointWSRepository.getSharepointConnection();
        this._sharepointConnectionInfo = sharepointConnection.getSharepointConnectionInfo();
        this._query = new Query(this.traverseQuery(query));
        QueryConfig queryConfig = searchContext.getQueryConfig();
        this._queryOptionsList = queryConfig.isSearchSubfolders() ? (this.isServerVersion(SharepointConnection.ServerVersion.SHAREPOINT_2013) ? new QueryOptionsList(new FolderQueryOption(""), new ViewAttributesQueryOption(true)) : new QueryOptionsList(new FolderQueryOption(""))) : new QueryOptionsList(new BaseQueryOption[0]);
        this.log(query);
    }

    public Query getQuery() {
        return this._query;
    }

    public QueryOptionsList getQueryOptionsList() {
        return this._queryOptionsList;
    }

    protected QueryClause buildFieldQueryClause(String fieldName, String fieldValue, SharepointQueryOperator sharepointQueryOperator) throws SearchException {
        QueryField queryField = new QueryField(this.getSharepointFieldName(fieldName));
        String formattedFieldValue = this.formatFieldValue(fieldName, fieldValue);
        QueryValue queryValue = new QueryValue(formattedFieldValue);
        if (sharepointQueryOperator == SharepointQueryOperator.EQ) {
            return new EqOperator(queryField, queryValue);
        }
        if (sharepointQueryOperator == SharepointQueryOperator.GEQ) {
            return new GeqOperator(queryField, queryValue);
        }
        if (sharepointQueryOperator == SharepointQueryOperator.GT) {
            return new GtOperator(queryField, queryValue);
        }
        if (sharepointQueryOperator == SharepointQueryOperator.LEQ) {
            return new LeqOperator(queryField, queryValue);
        }
        if (sharepointQueryOperator == SharepointQueryOperator.LIKE) {
            return this.buildLikeQueryClause(queryField, formattedFieldValue);
        }
        if (sharepointQueryOperator == SharepointQueryOperator.LT) {
            return new LtOperator(queryField, queryValue);
        }
        if (sharepointQueryOperator == SharepointQueryOperator.NEQ) {
            return new NeqOperator(queryField, queryValue);
        }
        throw new SearchException("Unsupported Sharepoint query operator " + (Object)((Object)sharepointQueryOperator));
    }

    protected QueryClause buildLikeQueryClause(QueryField queryField, String fieldValue) throws SearchException {
        QueryValue queryValue = new QueryValue(StringUtil.replace((String)fieldValue, (char)'*', (String)""));
        if (fieldValue.startsWith("*") && fieldValue.endsWith("*")) {
            return new ContainsOperator(queryField, queryValue);
        }
        if (fieldValue.endsWith("*")) {
            return new BeginsWithOperator(queryField, queryValue);
        }
        if (fieldValue.startsWith("*")) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Converting and ENDS-WITH query to a CONTAINS query due to repository limitations");
            }
            return new ContainsOperator(queryField, queryValue);
        }
        if (fieldValue.contains("*")) {
            String[] parts;
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Converting an INTERMEDIATE WILDCARD query to MULTIPLE CONTAINS queries due to repository limitations");
            }
            ArrayList<QueryClause> queryClauses = new ArrayList<QueryClause>();
            for (String part : parts = StringUtil.split((String)fieldValue, (String)"*")) {
                queryClauses.add(new ContainsOperator(queryField, new QueryValue(part)));
            }
            return this.joinWithAnd(queryClauses);
        }
        throw new SearchException("Unsupported LIKE value " + fieldValue);
    }

    protected String formatFieldValue(String fieldName, String fieldValue) throws SearchException {
        if (fieldName.equals("folderId")) {
            String folderId = this._extRepositoryQueryMapper.formatParameterValue(fieldName, fieldValue);
            try {
                SharepointWSFolder sharepointWSFolder = (SharepointWSFolder)this._sharepointWSRepository.getExtRepositoryObject(ExtRepositoryObjectType.FOLDER, folderId);
                SharepointObject folderSharepointObject = sharepointWSFolder.getSharepointObject();
                String folderPath = folderSharepointObject.getPath();
                SharepointConnection sharepointConnection = this._sharepointWSRepository.getSharepointConnection();
                SharepointConnectionInfo sharepointConnectionInfo = sharepointConnection.getSharepointConnectionInfo();
                String prefixPath = sharepointConnectionInfo.getLibraryPath();
                if (this.isServerVersion(SharepointConnection.ServerVersion.SHAREPOINT_2013)) {
                    prefixPath = this._sharepointConnectionInfo.getSitePath() + "/" + prefixPath;
                }
                if (folderPath.equals("/")) {
                    return prefixPath;
                }
                return prefixPath + folderPath;
            }
            catch (PortalException portalException) {
                throw new SearchException("Unable to get folder with folder ID" + folderId, (Throwable)portalException);
            }
            catch (SystemException systemException) {
                throw new SearchException("Unable to get folder with folder ID" + folderId, (Throwable)systemException);
            }
        }
        if (fieldName.equals("createDate") || fieldName.equals("modified")) {
            Date date = this._extRepositoryQueryMapper.formatDateParameterValue(fieldName, fieldValue);
            DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)_SHAREPOINT_DATE_FORMAT_PATTERN);
            return dateFormat.format(date);
        }
        if (fieldName.equals("userId") || fieldName.equals("userName")) {
            String screenName = this._extRepositoryQueryMapper.formatParameterValue(fieldName, fieldValue);
            return this._sharepointWSRepository.getSharepointLogin(screenName);
        }
        return this._extRepositoryQueryMapper.formatParameterValue(fieldName, fieldValue);
    }

    protected String getSharepointFieldName(String fieldName) {
        return _sharepointFields.get(fieldName);
    }

    protected boolean isServerVersion(SharepointConnection.ServerVersion serverVersion) {
        return serverVersion.equals((Object)this._sharepointConnectionInfo.getServerVersion());
    }

    protected boolean isSupportedField(String field) {
        return _supportedFields.contains(field);
    }

    protected QueryClause joinBooleanQueryClauses(List<QueryClause> andQueryClauses, List<QueryClause> notQueryClauses, List<QueryClause> orQueryClauses) throws SearchException {
        ArrayList<QueryClause> queryClauses = new ArrayList<QueryClause>();
        QueryClause queryClause = this.joinWithAnd(andQueryClauses);
        if (queryClause != null) {
            queryClauses.add(queryClause);
        }
        if ((queryClause = this.joinWithOr(orQueryClauses)) != null) {
            queryClauses.add(queryClause);
        }
        if ((queryClause = this.joinWithNot(notQueryClauses)) != null) {
            queryClauses.add(queryClause);
        }
        return this.joinWithAnd(queryClauses);
    }

    protected QueryClause joinWithAnd(List<QueryClause> queryClauses) {
        if (queryClauses.isEmpty()) {
            return null;
        }
        if (queryClauses.size() == 1) {
            return queryClauses.get(0);
        }
        QueryClause firstQueryClause = queryClauses.get(0);
        List<QueryClause> remainingQueryClauses = queryClauses.subList(1, queryClauses.size());
        return new AndJoin(firstQueryClause, this.joinWithAnd(remainingQueryClauses));
    }

    protected QueryClause joinWithNot(List<QueryClause> queryClauses) throws SearchException {
        QueryClause queryClause = this.joinWithAnd(queryClauses);
        if (queryClause == null) {
            return null;
        }
        return this.negate(queryClause);
    }

    protected QueryClause joinWithOr(List<QueryClause> queryClauses) {
        if (queryClauses.isEmpty()) {
            return null;
        }
        if (queryClauses.size() == 1) {
            return queryClauses.get(0);
        }
        QueryClause firstQueryClause = queryClauses.get(0);
        List<QueryClause> remainingQueryClauses = queryClauses.subList(1, queryClauses.size());
        return new OrJoin(firstQueryClause, this.joinWithOr(remainingQueryClauses));
    }

    protected void log(com.liferay.portal.kernel.search.Query query) {
        if (!_log.isDebugEnabled()) {
            return;
        }
        _log.debug((Object)("Liferay query: " + _liferayQueryExplainer.explain(query)));
        _log.debug((Object)("Sharepoint query: " + this._query));
        _log.debug((Object)("Sharepoint query options list: " + this._queryOptionsList));
    }

    protected QueryClause negate(QueryClause queryClause) throws SearchException {
        if (queryClause instanceof BaseJoin) {
            return this.negateBaseJoin((BaseJoin)queryClause);
        }
        if (queryClause instanceof BaseMultiValueOperator) {
            return this.negateBaseMultiValueOperator((BaseMultiValueOperator)queryClause);
        }
        if (queryClause instanceof BaseNoValueOperator) {
            return this.negateBaseNoValueOperator((BaseNoValueOperator)queryClause);
        }
        if (queryClause instanceof BaseSingleValueOperator) {
            return this.negateBaseSingleValueOperator((BaseSingleValueOperator)queryClause);
        }
        throw new SearchException("Unable to negate query clause " + queryClause);
    }

    protected QueryClause negateBaseJoin(BaseJoin baseJoin) throws SearchException {
        if (baseJoin instanceof AndJoin) {
            AndJoin andJoin = (AndJoin)baseJoin;
            return new OrJoin(this.negate(andJoin.getLeftQueryClause()), this.negate(andJoin.getRightQueryClause()));
        }
        if (baseJoin instanceof OrJoin) {
            OrJoin orJoin = (OrJoin)baseJoin;
            return new AndJoin(this.negate(orJoin.getLeftQueryClause()), this.negate(orJoin.getRightQueryClause()));
        }
        throw new SearchException("Unable to negate base join " + baseJoin);
    }

    protected QueryClause negateBaseMultiValueOperator(BaseMultiValueOperator baseMultiValueOperator) throws SearchException {
        throw new SearchException("Unable to negate base multi value operator " + baseMultiValueOperator);
    }

    protected QueryClause negateBaseNoValueOperator(BaseNoValueOperator baseNoValueOperator) throws SearchException {
        if (baseNoValueOperator instanceof IsNotNullOperator) {
            IsNotNullOperator isNotNullOperator = (IsNotNullOperator)baseNoValueOperator;
            return new IsNullOperator(isNotNullOperator.getQueryField());
        }
        if (baseNoValueOperator instanceof IsNullOperator) {
            IsNullOperator isNullOperator = (IsNullOperator)baseNoValueOperator;
            return new IsNotNullOperator(isNullOperator.getQueryField());
        }
        throw new SearchException("Unable to negate base no value operator " + baseNoValueOperator);
    }

    protected QueryClause negateBaseSingleValueOperator(BaseSingleValueOperator baseSingleValueOperator) throws SearchException {
        if (baseSingleValueOperator instanceof EqOperator) {
            EqOperator eqOperator = (EqOperator)baseSingleValueOperator;
            return new NeqOperator(eqOperator.getQueryField(), eqOperator.getQueryValue());
        }
        if (baseSingleValueOperator instanceof GeqOperator) {
            GeqOperator geqOperator = (GeqOperator)baseSingleValueOperator;
            return new LtOperator(geqOperator.getQueryField(), geqOperator.getQueryValue());
        }
        if (baseSingleValueOperator instanceof GtOperator) {
            GtOperator gtOperator = (GtOperator)baseSingleValueOperator;
            return new LeqOperator(gtOperator.getQueryField(), gtOperator.getQueryValue());
        }
        if (baseSingleValueOperator instanceof IncludesOperator) {
            IncludesOperator includesOperator = (IncludesOperator)baseSingleValueOperator;
            return new NotIncludesOperator(includesOperator.getQueryField(), includesOperator.getQueryValue());
        }
        if (baseSingleValueOperator instanceof LeqOperator) {
            LeqOperator leqOperator = (LeqOperator)baseSingleValueOperator;
            return new GtOperator(leqOperator.getQueryField(), leqOperator.getQueryValue());
        }
        if (baseSingleValueOperator instanceof LtOperator) {
            LtOperator ltOperator = (LtOperator)baseSingleValueOperator;
            return new GeqOperator(ltOperator.getQueryField(), ltOperator.getQueryValue());
        }
        if (baseSingleValueOperator instanceof NeqOperator) {
            NeqOperator neqOperator = (NeqOperator)baseSingleValueOperator;
            return new EqOperator(neqOperator.getQueryField(), neqOperator.getQueryValue());
        }
        if (baseSingleValueOperator instanceof NotIncludesOperator) {
            NotIncludesOperator notIncludesOperator = (NotIncludesOperator)baseSingleValueOperator;
            return new IncludesOperator(notIncludesOperator.getQueryField(), notIncludesOperator.getQueryValue());
        }
        throw new SearchException("Unable to negate base single value operator " + baseSingleValueOperator);
    }

    protected QueryClause traverseBooleanQuery(BooleanQuery booleanQuery) throws SearchException {
        ArrayList<QueryClause> andQueryClauses = new ArrayList<QueryClause>();
        ArrayList<QueryClause> notQueryClauses = new ArrayList<QueryClause>();
        ArrayList<QueryClause> orQueryClauses = new ArrayList<QueryClause>();
        for (BooleanClause booleanClause : booleanQuery.clauses()) {
            com.liferay.portal.kernel.search.Query query;
            QueryClause queryClause;
            ArrayList<QueryClause> queryClauses = orQueryClauses;
            BooleanClauseOccur booleanClauseOccur = booleanClause.getBooleanClauseOccur();
            if (booleanClauseOccur.equals(BooleanClauseOccur.MUST)) {
                queryClauses = andQueryClauses;
            } else if (booleanClauseOccur.equals(BooleanClauseOccur.MUST_NOT)) {
                queryClauses = notQueryClauses;
            }
            if ((queryClause = this.traverseQuery(query = (com.liferay.portal.kernel.search.Query)booleanClause.getClause())) == null) continue;
            queryClauses.add(queryClause);
        }
        return this.joinBooleanQueryClauses(andQueryClauses, notQueryClauses, orQueryClauses);
    }

    protected QueryClause traverseQuery(com.liferay.portal.kernel.search.Query query) throws SearchException {
        if (query instanceof BooleanQuery) {
            return this.traverseBooleanQuery((BooleanQuery)query);
        }
        if (query instanceof TermQuery) {
            return this.traverseTermQuery((TermQuery)query);
        }
        if (query instanceof TermRangeQuery) {
            return this.traverseTermRangeQuery((TermRangeQuery)query);
        }
        if (query instanceof WildcardQuery) {
            return this.traverseWildcardQuery((WildcardQuery)query);
        }
        Class<?> clazz = query.getClass();
        throw new SearchException("Unsupported query type " + clazz.getName());
    }

    protected QueryClause traverseTermQuery(TermQuery termQuery) throws SearchException {
        QueryTerm queryTerm = termQuery.getQueryTerm();
        if (!this.isSupportedField(queryTerm.getField())) {
            return null;
        }
        return this.buildFieldQueryClause(queryTerm.getField(), queryTerm.getValue(), SharepointQueryOperator.EQ);
    }

    protected QueryClause traverseTermRangeQuery(TermRangeQuery termRangeQuery) throws SearchException {
        if (!this.isSupportedField(termRangeQuery.getField())) {
            return null;
        }
        BaseSingleValueOperator lowerTermQueryClause = null;
        String fieldName = termRangeQuery.getField();
        QueryField queryField = new QueryField(this.getSharepointFieldName(fieldName));
        String lowerTermFieldValue = this.formatFieldValue(fieldName, termRangeQuery.getLowerTerm());
        QueryValue lowerTermQueryValue = new QueryValue(lowerTermFieldValue);
        lowerTermQueryClause = termRangeQuery.includesLower() ? new GeqOperator(queryField, lowerTermQueryValue) : new GtOperator(queryField, lowerTermQueryValue);
        BaseSingleValueOperator upperTermQueryClause = null;
        String upperTermFieldValue = this.formatFieldValue(fieldName, termRangeQuery.getUpperTerm());
        QueryValue upperTermQueryValue = new QueryValue(upperTermFieldValue);
        upperTermQueryClause = termRangeQuery.includesUpper() ? new LeqOperator(queryField, upperTermQueryValue) : new LtOperator(queryField, upperTermQueryValue);
        return new AndJoin(lowerTermQueryClause, upperTermQueryClause);
    }

    protected QueryClause traverseWildcardQuery(WildcardQuery wildcardQuery) throws SearchException {
        QueryTerm queryTerm = wildcardQuery.getQueryTerm();
        if (!this.isSupportedField(queryTerm.getField())) {
            return null;
        }
        return this.buildFieldQueryClause(queryTerm.getField(), queryTerm.getValue(), SharepointQueryOperator.LIKE);
    }
}

