/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.soap.repository;

import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.RepositoryConfiguration;
import com.liferay.portal.kernel.repository.RepositoryConfigurationBuilder;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.capabilities.PortalCapabilityLocator;
import com.liferay.portal.kernel.repository.capabilities.ProcessorCapability;
import com.liferay.portal.kernel.repository.registry.BaseRepositoryDefiner;
import com.liferay.portal.kernel.repository.registry.CapabilityRegistry;
import com.liferay.portal.kernel.repository.registry.RepositoryDefiner;
import com.liferay.portal.kernel.repository.registry.RepositoryFactoryRegistry;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.sharepoint.soap.repository.SharepointWSRepository;
import java.util.Locale;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={RepositoryDefiner.class})
public class SharepointWSRepositoryDefiner
extends BaseRepositoryDefiner {
    @Reference
    private PortalCapabilityLocator _portalCapabilityLocator;
    private RepositoryConfiguration _repositoryConfiguration;
    @Reference(target="(repository.target.class.name=com.liferay.sharepoint.soap.repository.SharepointWSRepository)")
    private RepositoryFactory _repositoryFactory;

    public String getClassName() {
        return SharepointWSRepository.class.getName();
    }

    public RepositoryConfiguration getRepositoryConfiguration() {
        return this._repositoryConfiguration;
    }

    public boolean isExternalRepository() {
        return true;
    }

    public void registerCapabilities(CapabilityRegistry<DocumentRepository> capabilityRegistry) {
        capabilityRegistry.addSupportedCapability(ProcessorCapability.class, (Capability)this._portalCapabilityLocator.getProcessorCapability((DocumentRepository)capabilityRegistry.getTarget(), ProcessorCapability.ResourceGenerationStrategy.ALWAYS_GENERATE));
    }

    public void registerRepositoryFactory(RepositoryFactoryRegistry repositoryFactoryRegistry) {
        repositoryFactoryRegistry.setRepositoryFactory(this._repositoryFactory);
    }

    @Activate
    protected void activate() {
        ResourceBundleLoader resourceBundleLoader = locale -> ResourceBundleUtil.getBundle((Locale)locale, ((Object)((Object)this)).getClass());
        RepositoryConfigurationBuilder repositoryConfigurationBuilder = new RepositoryConfigurationBuilder(resourceBundleLoader, new String[]{"LIBRARY_NAME", "LIBRARY_PATH", "SERVER_VERSION", "SITE_URL"});
        this._repositoryConfiguration = repositoryConfigurationBuilder.build();
    }

    @Deactivate
    protected void deactivate() {
        this._repositoryConfiguration = null;
    }
}

