/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.server.admin.web.internal.portlet.action;

import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCResourceCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.OutputStream;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.data.Range;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;
import org.osgi.service.component.annotations.Component;

@Component(property={"javax.portlet.name=com_liferay_server_admin_web_portlet_ServerAdminPortlet", "mvc.command.name=/server_admin/view_chart"}, service={MVCResourceCommand.class})
public class ViewChartMVCResourceCommand
extends BaseMVCResourceCommand {
    protected void doServeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String type = ParamUtil.getString((PortletRequest)resourceRequest, (String)"type", (String)"max");
        long maxMemory = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"maxMemory");
        long totalMemory = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"totalMemory");
        long usedMemory = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"usedMemory");
        DefaultValueDataset valueDataset = null;
        StringBundler sb = new StringBundler(5);
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)themeDisplay.getLocale(), ((Object)((Object)this)).getClass());
        sb.append(ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"used-memory"));
        sb.append(" ");
        sb.append("/");
        sb.append(" ");
        if (type.equals("total")) {
            valueDataset = new DefaultValueDataset((double)(usedMemory * 100L / totalMemory));
            sb.append(ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"total-memory"));
        } else {
            valueDataset = new DefaultValueDataset((double)(usedMemory * 100L / maxMemory));
            sb.append(ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"maximum-memory"));
        }
        MeterPlot meterPlot = this.getMeterPlot(themeDisplay, (ValueDataset)valueDataset);
        JFreeChart jFreeChart = this.getJFreeChart(sb.toString(), meterPlot);
        resourceResponse.setContentType("image/png");
        ChartUtilities.writeChartAsPNG((OutputStream)resourceResponse.getPortletOutputStream(), (JFreeChart)jFreeChart, (int)280, (int)180);
    }

    protected JFreeChart getJFreeChart(String title, MeterPlot meterPlot) {
        JFreeChart jFreeChart = new JFreeChart(title, new Font(null, 0, 13), (Plot)meterPlot, true);
        jFreeChart.removeLegend();
        jFreeChart.setBackgroundPaint((Paint)Color.white);
        return jFreeChart;
    }

    protected MeterPlot getMeterPlot(ThemeDisplay themeDisplay, ValueDataset valueDataset) {
        MeterPlot meterPlot = new MeterPlot(valueDataset);
        meterPlot.addInterval(new MeterInterval(themeDisplay.translate("normal"), new Range(0.0, 75.0), (Paint)Color.lightGray, (Stroke)new BasicStroke(2.0f), (Paint)new Color(0, 255, 0, 64)));
        meterPlot.addInterval(new MeterInterval(themeDisplay.translate("warning"), new Range(75.0, 90.0), (Paint)Color.lightGray, (Stroke)new BasicStroke(2.0f), (Paint)new Color(255, 255, 0, 64)));
        meterPlot.addInterval(new MeterInterval(themeDisplay.translate("critical"), new Range(90.0, 100.0), (Paint)Color.lightGray, (Stroke)new BasicStroke(2.0f), (Paint)new Color(255, 0, 0, 128)));
        meterPlot.setDialBackgroundPaint((Paint)Color.white);
        meterPlot.setDialShape(DialShape.PIE);
        meterPlot.setDialOutlinePaint((Paint)Color.gray);
        meterPlot.setTickLabelFont(new Font(null, 0, 10));
        meterPlot.setTickLabelPaint((Paint)Color.darkGray);
        meterPlot.setTickLabelsVisible(true);
        meterPlot.setTickPaint((Paint)Color.lightGray);
        meterPlot.setTickSize(5.0);
        meterPlot.setMeterAngle(180);
        meterPlot.setNeedlePaint((Paint)Color.darkGray);
        meterPlot.setRange(new Range(0.0, 100.0));
        meterPlot.setValueFont(new Font(null, 0, 10));
        meterPlot.setValuePaint((Paint)Color.black);
        meterPlot.setUnits("%");
        return meterPlot;
    }
}

