/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.server.admin.web.portlet.action;

import com.liferay.document.library.kernel.util.DLPreviewableProcessor;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.petra.log4j.Log4JUtil;
import com.liferay.portal.captcha.CaptchaImpl;
import com.liferay.portal.captcha.recaptcha.ReCaptchaImpl;
import com.liferay.portal.captcha.simplecaptcha.SimpleCaptchaImpl;
import com.liferay.portal.convert.ConvertException;
import com.liferay.portal.convert.ConvertProcess;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.SingleVMPool;
import com.liferay.portal.kernel.captcha.Captcha;
import com.liferay.portal.kernel.captcha.CaptchaUtil;
import com.liferay.portal.kernel.image.GhostscriptUtil;
import com.liferay.portal.kernel.image.ImageMagickUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.log.SanitizerLogWrapper;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.scripting.Scripting;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.scripting.ScriptingHelperUtil;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.membershippolicy.OrganizationMembershipPolicy;
import com.liferay.portal.kernel.security.membershippolicy.OrganizationMembershipPolicyFactory;
import com.liferay.portal.kernel.security.membershippolicy.RoleMembershipPolicy;
import com.liferay.portal.kernel.security.membershippolicy.RoleMembershipPolicyFactory;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicy;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicyFactory;
import com.liferay.portal.kernel.security.membershippolicy.UserGroupMembershipPolicy;
import com.liferay.portal.kernel.security.membershippolicy.UserGroupMembershipPolicyFactory;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceComponentLocalService;
import com.liferay.portal.kernel.servlet.DirectServletRegistry;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.ThreadUtil;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUID;
import com.liferay.portal.kernel.xuggler.XugglerInstallException;
import com.liferay.portal.kernel.xuggler.XugglerUtil;
import com.liferay.portal.security.lang.DoPrivilegedBean;
import com.liferay.portal.upload.UploadServletRequestImpl;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.ShutdownUtil;
import com.liferay.portlet.ActionResponseImpl;
import com.liferay.portlet.admin.util.CleanUpPermissionsUtil;
import com.liferay.portlet.admin.util.CleanUpPortletPreferencesUtil;
import java.io.File;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import org.apache.log4j.Level;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_server_admin_web_portlet_ServerAdminPortlet", "mvc.command.name=/server_admin/edit_server"}, service={MVCActionCommand.class})
public class EditServerMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(EditServerMVCActionCommand.class);
    @Reference
    private BackgroundTaskManager _backgroundTaskManager;
    @Reference
    private DirectServletRegistry _directServletRegistry;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference
    private MailService _mailService;
    @Reference
    private MessageBus _messageBus;
    @Reference
    private MultiVMPool _multiVMPool;
    @Reference
    private OrganizationMembershipPolicyFactory _organizationMembershipPolicyFactory;
    @Reference
    private PortalUUID _portalUUID;
    @Reference
    private RoleMembershipPolicyFactory _roleMembershipPolicyFactory;
    @Reference
    private Scripting _scripting;
    @Reference
    private ServiceComponentLocalService _serviceComponentLocalService;
    @Reference
    private SingleVMPool _singleVMPool;
    @Reference
    private SiteMembershipPolicyFactory _siteMembershipPolicyFactory;
    @Reference
    private UserGroupMembershipPolicyFactory _userGroupMembershipPolicyFactory;

    public void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.MustBeOmniadmin.class.getName());
            actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            return;
        }
        PortletPreferences portletPreferences = PrefsPropsUtil.getPreferences();
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        if (cmd.equals("addLogLevel")) {
            this.addLogLevel(actionRequest);
        } else if (cmd.equals("cacheDb")) {
            this.cacheDb();
        } else if (cmd.equals("cacheMulti")) {
            this.cacheMulti();
        } else if (cmd.equals("cacheServlet")) {
            this.cacheServlet();
        } else if (cmd.equals("cacheSingle")) {
            this.cacheSingle();
        } else if (cmd.equals("cleanUpPermissions")) {
            CleanUpPermissionsUtil.cleanUpAddToPagePermissions((ActionRequest)actionRequest);
        } else if (cmd.equals("cleanUpPortletPreferences")) {
            CleanUpPortletPreferencesUtil.cleanUpLayoutRevisionPortletPreferences();
        } else if (cmd.startsWith("convertProcess.")) {
            redirect = this.convertProcess(actionRequest, actionResponse, cmd);
        } else if (cmd.equals("dlPreviews")) {
            DLPreviewableProcessor.deleteFiles();
        } else if (cmd.equals("gc")) {
            this.gc();
        } else if (cmd.equals("installXuggler")) {
            try {
                this.installXuggler(actionRequest, actionResponse);
            }
            catch (XugglerInstallException xie) {
                SessionErrors.add((PortletRequest)actionRequest, (String)XugglerInstallException.class.getName(), (Object)((Object)xie));
            }
        } else if (cmd.equals("reindex")) {
            this.reindex(actionRequest);
        } else if (cmd.equals("reindexDictionaries")) {
            this.reindexDictionaries(actionRequest);
        } else if (cmd.equals("runScript")) {
            this.runScript(actionRequest, actionResponse);
        } else if (cmd.equals("shutdown")) {
            this.shutdown(actionRequest);
        } else if (cmd.equals("threadDump")) {
            this.threadDump();
        } else if (cmd.equals("updateCaptcha")) {
            this.updateCaptcha(actionRequest, portletPreferences);
        } else if (cmd.equals("updateExternalServices")) {
            this.updateExternalServices(actionRequest, portletPreferences);
        } else if (cmd.equals("updateFileUploads")) {
            this.updateFileUploads(actionRequest, portletPreferences);
        } else if (cmd.equals("updateLogLevels")) {
            this.updateLogLevels(actionRequest);
        } else if (cmd.equals("updateMail")) {
            this.updateMail(actionRequest, portletPreferences);
        } else if (cmd.equals("verifyMembershipPolicies")) {
            this.verifyMembershipPolicies();
        } else if (cmd.equals("verifyPluginTables")) {
            this.verifyPluginTables();
        }
        this.sendRedirect(actionRequest, actionResponse, redirect);
    }

    protected void addLogLevel(ActionRequest actionRequest) throws Exception {
        String loggerName = ParamUtil.getString((PortletRequest)actionRequest, (String)"loggerName");
        String priority = ParamUtil.getString((PortletRequest)actionRequest, (String)"priority");
        Log4JUtil.setLevel((String)loggerName, (String)priority, (boolean)true);
    }

    protected void cacheDb() throws Exception {
        CacheRegistryUtil.clear();
    }

    protected void cacheMulti() throws Exception {
        this._multiVMPool.clear();
    }

    protected void cacheServlet() throws Exception {
        this._directServletRegistry.clearServlets();
    }

    protected void cacheSingle() throws Exception {
        this._singleVMPool.clear();
    }

    protected String convertProcess(ActionRequest actionRequest, ActionResponse actionResponse, String cmd) throws Exception {
        ActionResponseImpl actionResponseImpl = (ActionResponseImpl)actionResponse;
        PortletSession portletSession = actionRequest.getPortletSession();
        String className = StringUtil.replaceFirst((String)cmd, (String)"convertProcess.", (String)"");
        ConvertProcess convertProcess = (ConvertProcess)InstancePool.get((String)className);
        String[] parameters = convertProcess.getParameterNames();
        if (parameters != null) {
            String[] values = new String[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                String parameter = className + "." + parameters[i];
                if (parameters[i].contains("=")) {
                    String[] parameterPair = StringUtil.split((String)parameters[i], (char)'=');
                    parameter = className + "." + parameterPair[0];
                }
                values[i] = ParamUtil.getString((PortletRequest)actionRequest, (String)parameter);
            }
            convertProcess.setParameterValues(values);
        }
        try {
            convertProcess.validate();
        }
        catch (ConvertException ce) {
            SessionErrors.add((PortletRequest)actionRequest, ((Object)((Object)ce)).getClass(), (Object)((Object)ce));
            return null;
        }
        String path = convertProcess.getPath();
        if (path != null) {
            PortletURL portletURL = actionResponseImpl.createRenderURL();
            portletURL.setParameter("mvcRenderCommandName", path);
            portletURL.setWindowState(WindowState.MAXIMIZED);
            return portletURL.toString();
        }
        MaintenanceUtil.maintain((String)portletSession.getId(), (String)className);
        MessageBusUtil.sendMessage((String)"liferay/convert_process", (Object)className);
        return null;
    }

    protected void gc() throws Exception {
        Runtime.getRuntime().gc();
    }

    protected String getFileExtensions(ActionRequest actionRequest, String name) {
        String value = ParamUtil.getString((PortletRequest)actionRequest, (String)name);
        return value.replace(", .", ",.");
    }

    protected void installXuggler(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String jarName = ParamUtil.getString((PortletRequest)actionRequest, (String)"jarName");
        XugglerUtil.installNativeLibraries((String)jarName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reindex(final ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        HashMap taskContextMap = new HashMap();
        String className = ParamUtil.getString((PortletRequest)actionRequest, (String)"className");
        if (!ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"blocking")) {
            this._indexWriterHelper.reindex(themeDisplay.getUserId(), "reindex", PortalInstances.getCompanyIds(), className, taskContextMap);
            return;
        }
        final String jobName = "reindex-".concat(this._portalUUID.generate());
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        MessageListener messageListener = new MessageListener(){

            public void receive(Message message) throws MessageListenerException {
                int status = message.getInteger("status");
                if (status != 5 && status != 2 && status != 3) {
                    return;
                }
                if (!jobName.equals(message.getString("name"))) {
                    return;
                }
                PortletSession portletSession = actionRequest.getPortletSession();
                long lastAccessedTime = portletSession.getLastAccessedTime();
                int maxInactiveInterval = portletSession.getMaxInactiveInterval();
                int extendedMaxInactiveIntervalTime = (int)(System.currentTimeMillis() - lastAccessedTime + (long)maxInactiveInterval);
                portletSession.setMaxInactiveInterval(extendedMaxInactiveIntervalTime);
                countDownLatch.countDown();
            }
        };
        this._messageBus.registerMessageListener("liferay/background_task_status", messageListener);
        try {
            this._indexWriterHelper.reindex(themeDisplay.getUserId(), jobName, PortalInstances.getCompanyIds(), className, taskContextMap);
            countDownLatch.await(ParamUtil.getLong((PortletRequest)actionRequest, (String)"timeout", (long)3600000L), TimeUnit.MILLISECONDS);
        }
        finally {
            this._messageBus.unregisterMessageListener("liferay/background_task_status", messageListener);
        }
    }

    protected void reindexDictionaries(ActionRequest actionRequest) throws Exception {
        long[] companyIds;
        for (long companyId : companyIds = PortalInstances.getCompanyIds()) {
            this._indexWriterHelper.indexQuerySuggestionDictionaries(companyId);
            this._indexWriterHelper.indexSpellCheckerDictionaries(companyId);
        }
    }

    protected void runScript(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String language = ParamUtil.getString((PortletRequest)actionRequest, (String)"language");
        String script = ParamUtil.getString((PortletRequest)actionRequest, (String)"script");
        PortletConfig portletConfig = this.getPortletConfig((PortletRequest)actionRequest);
        PortletContext portletContext = portletConfig.getPortletContext();
        Map portletObjects = ScriptingHelperUtil.getPortletObjects((PortletConfig)portletConfig, (PortletContext)portletContext, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        UnsyncPrintWriter unsyncPrintWriter = UnsyncPrintWriterPool.borrow((OutputStream)unsyncByteArrayOutputStream);
        portletObjects.put("out", unsyncPrintWriter);
        try {
            SessionMessages.add((PortletRequest)actionRequest, (String)"language", (Object)language);
            SessionMessages.add((PortletRequest)actionRequest, (String)"script", (Object)script);
            this._scripting.exec(null, portletObjects, language, script);
            unsyncPrintWriter.flush();
            SessionMessages.add((PortletRequest)actionRequest, (String)"scriptOutput", (Object)unsyncByteArrayOutputStream.toString());
        }
        catch (ScriptingException se) {
            SessionErrors.add((PortletRequest)actionRequest, (String)ScriptingException.class.getName(), (Object)((Object)se));
            Log log = SanitizerLogWrapper.allowCRLF((Log)_log);
            log.error((Object)se.getMessage());
        }
    }

    protected void shutdown(ActionRequest actionRequest) throws Exception {
        if (ShutdownUtil.isInProcess()) {
            ShutdownUtil.cancel();
        } else {
            long minutes = (long)ParamUtil.getInteger((PortletRequest)actionRequest, (String)"minutes") * 60000L;
            if (minutes <= 0L) {
                SessionErrors.add((PortletRequest)actionRequest, (String)"shutdownMinutes");
            } else {
                String message = ParamUtil.getString((PortletRequest)actionRequest, (String)"message");
                ShutdownUtil.shutdown((long)minutes, (String)message);
            }
        }
    }

    protected void threadDump() throws Exception {
        if (_log.isInfoEnabled()) {
            Log log = SanitizerLogWrapper.allowCRLF((Log)_log);
            log.info((Object)ThreadUtil.threadDump());
        } else {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            _log.error((Object)("Thread dumps require the log level to be at least INFO for " + clazz.getName()));
        }
    }

    protected void updateCaptcha(ActionRequest actionRequest, PortletPreferences portletPreferences) throws Exception {
        boolean reCaptchaEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"reCaptchaEnabled");
        String reCaptchaPrivateKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"reCaptchaPrivateKey");
        String reCaptchaPublicKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"reCaptchaPublicKey");
        Object captcha = null;
        captcha = reCaptchaEnabled ? new ReCaptchaImpl() : new SimpleCaptchaImpl();
        this.validateCaptcha(actionRequest);
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            Class<?> clazz = captcha.getClass();
            portletPreferences.setValue("captcha.engine.impl", clazz.getName());
            portletPreferences.setValue("captcha.engine.recaptcha.key.private", reCaptchaPrivateKey);
            portletPreferences.setValue("captcha.engine.recaptcha.key.public", reCaptchaPublicKey);
            portletPreferences.store();
            CaptchaImpl captchaImpl = null;
            Captcha currentCaptcha = CaptchaUtil.getCaptcha();
            if (currentCaptcha instanceof DoPrivilegedBean) {
                DoPrivilegedBean doPrivilegedBean = (DoPrivilegedBean)currentCaptcha;
                captchaImpl = (CaptchaImpl)doPrivilegedBean.getActualBean();
            } else {
                captchaImpl = (CaptchaImpl)currentCaptcha;
            }
            captchaImpl.setCaptcha((Captcha)captcha);
        }
    }

    protected void updateExternalServices(ActionRequest actionRequest, PortletPreferences portletPreferences) throws Exception {
        boolean imageMagickEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"imageMagickEnabled");
        String imageMagickPath = ParamUtil.getString((PortletRequest)actionRequest, (String)"imageMagickPath");
        boolean openOfficeEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"openOfficeEnabled");
        int openOfficePort = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"openOfficePort");
        boolean xugglerEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"xugglerEnabled");
        portletPreferences.setValue("imagemagick.enabled", String.valueOf(imageMagickEnabled));
        portletPreferences.setValue("imagemagick.global.search.path", imageMagickPath);
        portletPreferences.setValue("openoffice.server.enabled", String.valueOf(openOfficeEnabled));
        portletPreferences.setValue("openoffice.server.port", String.valueOf(openOfficePort));
        portletPreferences.setValue("xuggler.enabled", String.valueOf(xugglerEnabled));
        Enumeration enu = actionRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.startsWith("imageMagickLimit")) continue;
            String key = StringUtil.toLowerCase((String)name.substring(16, name.length()));
            String value = ParamUtil.getString((PortletRequest)actionRequest, (String)name);
            portletPreferences.setValue("imagemagick.resource.limit." + key, value);
        }
        portletPreferences.store();
        GhostscriptUtil.reset();
        ImageMagickUtil.reset();
    }

    protected void updateFileUploads(ActionRequest actionRequest, PortletPreferences portletPreferences) throws Exception {
        long dlFileEntryPreviewableProcessorMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"dlFileEntryPreviewableProcessorMaxSize");
        long dlFileEntryThumbnailMaxHeight = ParamUtil.getLong((PortletRequest)actionRequest, (String)"dlFileEntryThumbnailMaxHeight");
        long dlFileEntryThumbnailMaxWidth = ParamUtil.getLong((PortletRequest)actionRequest, (String)"dlFileEntryThumbnailMaxWidth");
        String dlFileExtensions = this.getFileExtensions(actionRequest, "dlFileExtensions");
        long dlFileMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"dlFileMaxSize");
        String journalImageExtensions = this.getFileExtensions(actionRequest, "journalImageExtensions");
        long journalImageSmallMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"journalImageSmallMaxSize");
        String shoppingImageExtensions = this.getFileExtensions(actionRequest, "shoppingImageExtensions");
        long shoppingImageLargeMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"shoppingImageLargeMaxSize");
        long shoppingImageMediumMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"shoppingImageMediumMaxSize");
        long shoppingImageSmallMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"shoppingImageSmallMaxSize");
        long uploadServletRequestImplMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"uploadServletRequestImplMaxSize");
        String uploadServletRequestImplTempDir = ParamUtil.getString((PortletRequest)actionRequest, (String)"uploadServletRequestImplTempDir");
        long usersImageMaxSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"usersImageMaxSize");
        portletPreferences.setValue("dl.file.entry.previewable.processor.max.size", String.valueOf(dlFileEntryPreviewableProcessorMaxSize));
        portletPreferences.setValue("dl.file.entry.thumbnail.max.height", String.valueOf(dlFileEntryThumbnailMaxHeight));
        portletPreferences.setValue("dl.file.entry.thumbnail.max.width", String.valueOf(dlFileEntryThumbnailMaxWidth));
        portletPreferences.setValue("dl.file.extensions", dlFileExtensions);
        portletPreferences.setValue("dl.file.max.size", String.valueOf(dlFileMaxSize));
        portletPreferences.setValue("journal.image.extensions", journalImageExtensions);
        portletPreferences.setValue("journal.image.small.max.size", String.valueOf(journalImageSmallMaxSize));
        portletPreferences.setValue("shopping.image.extensions", shoppingImageExtensions);
        portletPreferences.setValue("shopping.image.large.max.size", String.valueOf(shoppingImageLargeMaxSize));
        portletPreferences.setValue("shopping.image.medium.max.size", String.valueOf(shoppingImageMediumMaxSize));
        portletPreferences.setValue("shopping.image.small.max.size", String.valueOf(shoppingImageSmallMaxSize));
        portletPreferences.setValue("com.liferay.portal.upload.UploadServletRequestImpl.max.size", String.valueOf(uploadServletRequestImplMaxSize));
        if (Validator.isNotNull((String)uploadServletRequestImplTempDir)) {
            portletPreferences.setValue("com.liferay.portal.upload.UploadServletRequestImpl.temp.dir", uploadServletRequestImplTempDir);
            UploadServletRequestImpl.setTempDir((File)new File(uploadServletRequestImplTempDir));
        }
        portletPreferences.setValue("users.image.max.size", String.valueOf(usersImageMaxSize));
        portletPreferences.store();
    }

    protected void updateLogLevels(ActionRequest actionRequest) throws Exception {
        Enumeration enu = actionRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.startsWith("logLevel")) continue;
            String loggerName = name.substring(8);
            String priority = ParamUtil.getString((PortletRequest)actionRequest, (String)name, (String)Level.INFO.toString());
            Log4JUtil.setLevel((String)loggerName, (String)priority, (boolean)true);
        }
    }

    protected void updateMail(ActionRequest actionRequest, PortletPreferences portletPreferences) throws Exception {
        String advancedProperties = ParamUtil.getString((PortletRequest)actionRequest, (String)"advancedProperties");
        String pop3Host = ParamUtil.getString((PortletRequest)actionRequest, (String)"pop3Host");
        String pop3Password = ParamUtil.getString((PortletRequest)actionRequest, (String)"pop3Password");
        int pop3Port = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"pop3Port");
        boolean pop3Secure = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"pop3Secure");
        String pop3User = ParamUtil.getString((PortletRequest)actionRequest, (String)"pop3User");
        String smtpHost = ParamUtil.getString((PortletRequest)actionRequest, (String)"smtpHost");
        String smtpPassword = ParamUtil.getString((PortletRequest)actionRequest, (String)"smtpPassword");
        int smtpPort = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"smtpPort");
        boolean smtpSecure = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"smtpSecure");
        String smtpUser = ParamUtil.getString((PortletRequest)actionRequest, (String)"smtpUser");
        String storeProtocol = "pop3";
        if (pop3Secure) {
            storeProtocol = "pop3s";
        }
        String transportProtocol = "smtp";
        if (smtpSecure) {
            transportProtocol = "smtps";
        }
        portletPreferences.setValue("mail.session.mail", "true");
        portletPreferences.setValue("mail.session.mail.advanced.properties", advancedProperties);
        portletPreferences.setValue("mail.session.mail.pop3.host", pop3Host);
        if (!pop3Password.equals("TEMP_OBFUSCATION_VALUE")) {
            portletPreferences.setValue("mail.session.mail.pop3.password", pop3Password);
        }
        portletPreferences.setValue("mail.session.mail.pop3.port", String.valueOf(pop3Port));
        portletPreferences.setValue("mail.session.mail.pop3.user", pop3User);
        portletPreferences.setValue("mail.session.mail.smtp.host", smtpHost);
        if (!smtpPassword.equals("TEMP_OBFUSCATION_VALUE")) {
            portletPreferences.setValue("mail.session.mail.smtp.password", smtpPassword);
        }
        portletPreferences.setValue("mail.session.mail.smtp.port", String.valueOf(smtpPort));
        portletPreferences.setValue("mail.session.mail.smtp.user", smtpUser);
        portletPreferences.setValue("mail.session.mail.store.protocol", storeProtocol);
        portletPreferences.setValue("mail.session.mail.transport.protocol", transportProtocol);
        portletPreferences.store();
        this._mailService.clearSession();
    }

    protected void validateCaptcha(ActionRequest actionRequest) throws Exception {
        boolean reCaptchaEnabled = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"reCaptchaEnabled");
        if (!reCaptchaEnabled) {
            return;
        }
        String reCaptchaPrivateKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"reCaptchaPrivateKey");
        String reCaptchaPublicKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"reCaptchaPublicKey");
        if (Validator.isNull((String)reCaptchaPublicKey)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"reCaptchaPublicKey");
        } else if (Validator.isNull((String)reCaptchaPrivateKey)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"reCaptchaPrivateKey");
        }
    }

    protected void verifyMembershipPolicies() throws Exception {
        OrganizationMembershipPolicy organizationMembershipPolicy = this._organizationMembershipPolicyFactory.getOrganizationMembershipPolicy();
        organizationMembershipPolicy.verifyPolicy();
        RoleMembershipPolicy roleMembershipPolicy = this._roleMembershipPolicyFactory.getRoleMembershipPolicy();
        roleMembershipPolicy.verifyPolicy();
        SiteMembershipPolicy siteMembershipPolicy = this._siteMembershipPolicyFactory.getSiteMembershipPolicy();
        siteMembershipPolicy.verifyPolicy();
        UserGroupMembershipPolicy userGroupMembershipPolicy = this._userGroupMembershipPolicyFactory.getUserGroupMembershipPolicy();
        userGroupMembershipPolicy.verifyPolicy();
    }

    protected void verifyPluginTables() throws Exception {
        this._serviceComponentLocalService.verifyDB();
    }
}

