import Utils from "./utils";
import Lexer from "./lexer";
export declare namespace PrimitiveLiteral {
    function nullValue(value: Utils.SourceArray, index: number): Lexer.Token;
    function booleanValue(value: Utils.SourceArray, index: number): Lexer.Token;
    function guidValue(value: any, index: any): Lexer.Token;
    function sbyteValue(value: Utils.SourceArray, index: number): Lexer.Token;
    function byteValue(value: Utils.SourceArray, index: number): Lexer.Token;
    function int16Value(value: Utils.SourceArray, index: number): Lexer.Token;
    function int32Value(value: Utils.SourceArray, index: number): Lexer.Token;
    function int64Value(value: Utils.SourceArray, index: number): Lexer.Token;
    function decimalValue(value: Utils.SourceArray, index: number): Lexer.Token;
    function doubleValue(value: Utils.SourceArray, index: number): Lexer.Token;
    function singleValue(value: Utils.SourceArray, index: number): Lexer.Token;
    function stringValue(value: Utils.SourceArray, index: number): Lexer.Token;
    function durationValue(value: Utils.SourceArray, index: number): Lexer.Token;
    function binaryValue(value: Utils.SourceArray, index: number): Lexer.Token;
    function dateValue(value: Utils.SourceArray, index: number): Lexer.Token;
    function dateTimeOffsetValue(value: Utils.SourceArray, index: number): Lexer.Token;
    function timeOfDayValue(value: Utils.SourceArray, index: number): Lexer.Token;
    function positionLiteral(value: Utils.SourceArray, index: number): Lexer.Token;
    function pointData(value: Utils.SourceArray, index: number): Lexer.Token;
    function lineStringData(value: Utils.SourceArray, index: number): Lexer.Token;
    function ringLiteral(value: Utils.SourceArray, index: number): Lexer.Token;
    function polygonData(value: Utils.SourceArray, index: number): Lexer.Token;
    function sridLiteral(value: Utils.SourceArray, index: number): Lexer.Token;
    function pointLiteral(value: Utils.SourceArray, index: number): Lexer.Token;
    function polygonLiteral(value: Utils.SourceArray, index: number): Lexer.Token;
    function collectionLiteral(value: Utils.SourceArray, index: number): Lexer.Token;
    function lineStringLiteral(value: Utils.SourceArray, index: number): Lexer.Token;
    function multiLineStringLiteral(value: Utils.SourceArray, index: number): Lexer.Token;
    function multiPointLiteral(value: Utils.SourceArray, index: number): Lexer.Token;
    function multiPolygonLiteral(value: Utils.SourceArray, index: number): Lexer.Token;
    function multiGeoLiteralFactory(value: Utils.SourceArray, index: number, prefix: string, itemLiteral: Function): Lexer.Token;
    function multiGeoLiteralOptionalFactory(value: Utils.SourceArray, index: number, prefix: string, itemLiteral: Function): Lexer.Token;
    function geoLiteral(value: Utils.SourceArray, index: number): Lexer.Token;
    function fullPointLiteral(value: Utils.SourceArray, index: number): Lexer.Token;
    function fullCollectionLiteral(value: Utils.SourceArray, index: number): Lexer.Token;
    function fullLineStringLiteral(value: Utils.SourceArray, index: number): Lexer.Token;
    function fullMultiLineStringLiteral(value: Utils.SourceArray, index: number): Lexer.Token;
    function fullMultiPointLiteral(value: Utils.SourceArray, index: number): Lexer.Token;
    function fullMultiPolygonLiteral(value: Utils.SourceArray, index: number): Lexer.Token;
    function fullPolygonLiteral(value: Utils.SourceArray, index: number): Lexer.Token;
    function fullGeoLiteralFactory(value: Utils.SourceArray, index: number, literal: Function): Lexer.Token;
    function geographyCollection(value: Utils.SourceArray, index: number): Lexer.Token;
    function geographyLineString(value: Utils.SourceArray, index: number): Lexer.Token;
    function geographyMultiLineString(value: Utils.SourceArray, index: number): Lexer.Token;
    function geographyMultiPoint(value: Utils.SourceArray, index: number): Lexer.Token;
    function geographyMultiPolygon(value: Utils.SourceArray, index: number): Lexer.Token;
    function geographyPoint(value: Utils.SourceArray, index: number): Lexer.Token;
    function geographyPolygon(value: Utils.SourceArray, index: number): Lexer.Token;
    function geometryCollection(value: Utils.SourceArray, index: number): Lexer.Token;
    function geometryLineString(value: Utils.SourceArray, index: number): Lexer.Token;
    function geometryMultiLineString(value: Utils.SourceArray, index: number): Lexer.Token;
    function geometryMultiPoint(value: Utils.SourceArray, index: number): Lexer.Token;
    function geometryMultiPolygon(value: Utils.SourceArray, index: number): Lexer.Token;
    function geometryPoint(value: Utils.SourceArray, index: number): Lexer.Token;
    function geometryPolygon(value: Utils.SourceArray, index: number): Lexer.Token;
    function geoLiteralFactory(value: Utils.SourceArray, index: number, type: string, prefix: Function, literal: Function): Lexer.Token;
    function primitiveLiteral(value: Utils.SourceArray, index: number): Lexer.Token;
}
export default PrimitiveLiteral;
