import Utils from "./utils";
import Lexer from "./lexer";
export declare namespace NameOrIdentifier {
    function enumeration(value: Utils.SourceArray, index: number): Lexer.Token;
    function enumValue(value: Utils.SourceArray, index: number): Lexer.Token;
    function singleEnumValue(value: Utils.SourceArray, index: number): Lexer.Token;
    function enumMemberValue(value: Utils.SourceArray, index: number): Lexer.Token;
    function singleQualifiedTypeName(value: Utils.SourceArray, index: number): Lexer.Token;
    function qualifiedTypeName(value: Utils.SourceArray, index: number): Lexer.Token;
    function qualifiedEntityTypeName(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
    function qualifiedComplexTypeName(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
    function qualifiedTypeDefinitionName(value: Utils.SourceArray, index: number): Lexer.Token;
    function qualifiedEnumTypeName(value: Utils.SourceArray, index: number): Lexer.Token;
    function namespace(value: Utils.SourceArray, index: number): number;
    function odataIdentifier(value: Utils.SourceArray, index: number, tokenType?: Lexer.TokenType): Lexer.Token;
    function namespacePart(value: Utils.SourceArray, index: number): Lexer.Token;
    function entitySetName(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
    function singletonEntity(value: Utils.SourceArray, index: number): Lexer.Token;
    function entityTypeName(value: Utils.SourceArray, index: number, schema?: any): Lexer.Token;
    function complexTypeName(value: Utils.SourceArray, index: number, schema?: any): Lexer.Token;
    function typeDefinitionName(value: Utils.SourceArray, index: number): Lexer.Token;
    function enumerationTypeName(value: Utils.SourceArray, index: number): Lexer.Token;
    function enumerationMember(value: Utils.SourceArray, index: number): Lexer.Token;
    function termName(value: Utils.SourceArray, index: number): Lexer.Token;
    function primitiveTypeName(value: Utils.SourceArray, index: number): Lexer.Token;
    function isPrimitiveTypeName(type: string, metadataContext?: any): boolean;
    function getMetadataRoot(metadataContext: any): any;
    function primitiveProperty(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
    function primitiveKeyProperty(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
    function primitiveNonKeyProperty(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
    function primitiveColProperty(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
    function complexProperty(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
    function complexColProperty(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
    function streamProperty(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
    function navigationProperty(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
    function entityNavigationProperty(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
    function entityColNavigationProperty(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
    function action(value: Utils.SourceArray, index: number, isCollection?: boolean, metadataContext?: any): Lexer.Token;
    function actionImport(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
    function odataFunction(value: Utils.SourceArray, index: number): Lexer.Token;
    function getOperationType(operation: string, metadataContext: any, token: Lexer.Token, isBoundCollection: boolean, isCollection: boolean, isPrimitive: boolean, types?: string): any;
    function entityFunction(value: Utils.SourceArray, index: number, isCollection?: boolean, metadataContext?: any): Lexer.Token;
    function entityColFunction(value: Utils.SourceArray, index: number, isCollection?: boolean, metadataContext?: any): Lexer.Token;
    function complexFunction(value: Utils.SourceArray, index: number, isCollection?: boolean, metadataContext?: any): Lexer.Token;
    function complexColFunction(value: Utils.SourceArray, index: number, isCollection?: boolean, metadataContext?: any): Lexer.Token;
    function primitiveFunction(value: Utils.SourceArray, index: number, isCollection?: boolean, metadataContext?: any): Lexer.Token;
    function primitiveColFunction(value: Utils.SourceArray, index: number, isCollection?: boolean, metadataContext?: any): Lexer.Token;
    function getOperationImportType(operation: string, metadataContext: any, token: Lexer.Token, isCollection?: boolean, isPrimitive?: boolean, types?: string): any;
    function entityFunctionImport(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
    function entityColFunctionImport(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
    function complexFunctionImport(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
    function complexColFunctionImport(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
    function primitiveFunctionImport(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
    function primitiveColFunctionImport(value: Utils.SourceArray, index: number, metadataContext?: any): Lexer.Token;
}
export default NameOrIdentifier;
