Liferay.Loader.define('segments-web$lodash@4.17.19/zipObjectDeep', ['module', 'exports', 'require', './_baseSet', './_baseZipObject'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var baseSet = require('./_baseSet'),
        baseZipObject = require('./_baseZipObject');

    /**
     * This method is like `_.zipObject` except that it supports property paths.
     *
     * @static
     * @memberOf _
     * @since 4.1.0
     * @category Array
     * @param {Array} [props=[]] The property identifiers.
     * @param {Array} [values=[]] The property values.
     * @returns {Object} Returns the new object.
     * @example
     *
     * _.zipObjectDeep(['a.b[0].c', 'a.b[1].d'], [1, 2]);
     * // => { 'a': { 'b': [{ 'c': 1 }, { 'd': 2 }] } }
     */
    function zipObjectDeep(props, values) {
      return baseZipObject(props || [], values || [], baseSet);
    }

    module.exports = zipObjectDeep;
  }
});
//# sourceMappingURL=zipObjectDeep.js.map