Liferay.Loader.define('segments-web$lodash@4.17.19/startCase', ['module', 'exports', 'require', './_createCompounder', './upperFirst'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var createCompounder = require('./_createCompounder'),
        upperFirst = require('./upperFirst');

    /**
     * Converts `string` to
     * [start case](https://en.wikipedia.org/wiki/Letter_case#Stylistic_or_specialised_usage).
     *
     * @static
     * @memberOf _
     * @since 3.1.0
     * @category String
     * @param {string} [string=''] The string to convert.
     * @returns {string} Returns the start cased string.
     * @example
     *
     * _.startCase('--foo-bar--');
     * // => 'Foo Bar'
     *
     * _.startCase('fooBar');
     * // => 'Foo Bar'
     *
     * _.startCase('__FOO_BAR__');
     * // => 'FOO BAR'
     */
    var startCase = createCompounder(function (result, word, index) {
      return result + (index ? ' ' : '') + upperFirst(word);
    });

    module.exports = startCase;
  }
});
//# sourceMappingURL=startCase.js.map