Liferay.Loader.define('segments-web$lodash@4.17.19/sortedLastIndex', ['module', 'exports', 'require', './_baseSortedIndex'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var baseSortedIndex = require('./_baseSortedIndex');

    /**
     * This method is like `_.sortedIndex` except that it returns the highest
     * index at which `value` should be inserted into `array` in order to
     * maintain its sort order.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Array
     * @param {Array} array The sorted array to inspect.
     * @param {*} value The value to evaluate.
     * @returns {number} Returns the index at which `value` should be inserted
     *  into `array`.
     * @example
     *
     * _.sortedLastIndex([4, 5, 5, 5, 6], 5);
     * // => 4
     */
    function sortedLastIndex(array, value) {
      return baseSortedIndex(array, value, true);
    }

    module.exports = sortedLastIndex;
  }
});
//# sourceMappingURL=sortedLastIndex.js.map