Liferay.Loader.define('segments-web$lodash@4.17.19/isInteger', ['module', 'exports', 'require', './toInteger'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var toInteger = require('./toInteger');

    /**
     * Checks if `value` is an integer.
     *
     * **Note:** This method is based on
     * [`Number.isInteger`](https://mdn.io/Number/isInteger).
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is an integer, else `false`.
     * @example
     *
     * _.isInteger(3);
     * // => true
     *
     * _.isInteger(Number.MIN_VALUE);
     * // => false
     *
     * _.isInteger(Infinity);
     * // => false
     *
     * _.isInteger('3');
     * // => false
     */
    function isInteger(value) {
      return typeof value == 'number' && value == toInteger(value);
    }

    module.exports = isInteger;
  }
});
//# sourceMappingURL=isInteger.js.map