Liferay.Loader.define('segments-web$lodash@4.17.19/forOwnRight', ['module', 'exports', 'require', './_baseForOwnRight', './_castFunction'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var baseForOwnRight = require('./_baseForOwnRight'),
        castFunction = require('./_castFunction');

    /**
     * This method is like `_.forOwn` except that it iterates over properties of
     * `object` in the opposite order.
     *
     * @static
     * @memberOf _
     * @since 2.0.0
     * @category Object
     * @param {Object} object The object to iterate over.
     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
     * @returns {Object} Returns `object`.
     * @see _.forOwn
     * @example
     *
     * function Foo() {
     *   this.a = 1;
     *   this.b = 2;
     * }
     *
     * Foo.prototype.c = 3;
     *
     * _.forOwnRight(new Foo, function(value, key) {
     *   console.log(key);
     * });
     * // => Logs 'b' then 'a' assuming `_.forOwn` logs 'a' then 'b'.
     */
    function forOwnRight(object, iteratee) {
      return object && baseForOwnRight(object, castFunction(iteratee));
    }

    module.exports = forOwnRight;
  }
});
//# sourceMappingURL=forOwnRight.js.map