Liferay.Loader.define('segments-web$lodash@4.17.19/attempt', ['module', 'exports', 'require', './_apply', './_baseRest', './isError'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var apply = require('./_apply'),
        baseRest = require('./_baseRest'),
        isError = require('./isError');

    /**
     * Attempts to invoke `func`, returning either the result or the caught error
     * object. Any additional arguments are provided to `func` when it's invoked.
     *
     * @static
     * @memberOf _
     * @since 3.0.0
     * @category Util
     * @param {Function} func The function to attempt.
     * @param {...*} [args] The arguments to invoke `func` with.
     * @returns {*} Returns the `func` result or error object.
     * @example
     *
     * // Avoid throwing errors for invalid selectors.
     * var elements = _.attempt(function(selector) {
     *   return document.querySelectorAll(selector);
     * }, '>_>');
     *
     * if (_.isError(elements)) {
     *   elements = [];
     * }
     */
    var attempt = baseRest(function (func, args) {
      try {
        return apply(func, undefined, args);
      } catch (e) {
        return isError(e) ? e : new Error(e);
      }
    });

    module.exports = attempt;
  }
});
//# sourceMappingURL=attempt.js.map