Liferay.Loader.define('segments-web$lodash@4.17.19/_baseKeysIn', ['module', 'exports', 'require', './isObject', './_isPrototype', './_nativeKeysIn'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var isObject = require('./isObject'),
        isPrototype = require('./_isPrototype'),
        nativeKeysIn = require('./_nativeKeysIn');

    /** Used for built-in method references. */
    var objectProto = Object.prototype;

    /** Used to check objects for own properties. */
    var hasOwnProperty = objectProto.hasOwnProperty;

    /**
     * The base implementation of `_.keysIn` which doesn't treat sparse arrays as dense.
     *
     * @private
     * @param {Object} object The object to query.
     * @returns {Array} Returns the array of property names.
     */
    function baseKeysIn(object) {
      if (!isObject(object)) {
        return nativeKeysIn(object);
      }
      var isProto = isPrototype(object),
          result = [];

      for (var key in object) {
        if (!(key == 'constructor' && (isProto || !hasOwnProperty.call(object, key)))) {
          result.push(key);
        }
      }
      return result;
    }

    module.exports = baseKeysIn;
  }
});
//# sourceMappingURL=_baseKeysIn.js.map