Liferay.Loader.define('segments-web$lodash@4.17.19/_assignValue', ['module', 'exports', 'require', './_baseAssignValue', './eq'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var baseAssignValue = require('./_baseAssignValue'),
        eq = require('./eq');

    /** Used for built-in method references. */
    var objectProto = Object.prototype;

    /** Used to check objects for own properties. */
    var hasOwnProperty = objectProto.hasOwnProperty;

    /**
     * Assigns `value` to `key` of `object` if the existing value is not equivalent
     * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
     * for equality comparisons.
     *
     * @private
     * @param {Object} object The object to modify.
     * @param {string} key The key of the property to assign.
     * @param {*} value The value to assign.
     */
    function assignValue(object, key, value) {
      var objValue = object[key];
      if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) || value === undefined && !(key in object)) {
        baseAssignValue(object, key, value);
      }
    }

    module.exports = assignValue;
  }
});
//# sourceMappingURL=_assignValue.js.map