Liferay.Loader.define("segments-web$date-fns@1.30.1/start_of_yesterday/index", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    /**
     * @category Day Helpers
     * @summary Return the start of yesterday.
     *
     * @description
     * Return the start of yesterday.
     *
     * @returns {Date} the start of yesterday
     *
     * @example
     * // If today is 6 October 2014:
     * var result = startOfYesterday()
     * //=> Sun Oct 5 2014 00:00:00
     */
    function startOfYesterday() {
      var now = new Date();
      var year = now.getFullYear();
      var month = now.getMonth();
      var day = now.getDate();

      var date = new Date(0);
      date.setFullYear(year, month, day - 1);
      date.setHours(0, 0, 0, 0);
      return date;
    }

    module.exports = startOfYesterday;
  }
});
//# sourceMappingURL=index.js.map