Liferay.Loader.define('segments-web$date-fns@1.30.1/set_iso_week/index', ['module', 'exports', 'require', '../parse/index', '../get_iso_week/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var parse = require('../parse/index');
    var getISOWeek = require('../get_iso_week/index');

    /**
     * @category ISO Week Helpers
     * @summary Set the ISO week to the given date.
     *
     * @description
     * Set the ISO week to the given date, saving the weekday number.
     *
     * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
     *
     * @param {Date|String|Number} date - the date to be changed
     * @param {Number} isoWeek - the ISO week of the new date
     * @returns {Date} the new date with the ISO week setted
     *
     * @example
     * // Set the 53rd ISO week to 7 August 2004:
     * var result = setISOWeek(new Date(2004, 7, 7), 53)
     * //=> Sat Jan 01 2005 00:00:00
     */
    function setISOWeek(dirtyDate, dirtyISOWeek) {
      var date = parse(dirtyDate);
      var isoWeek = Number(dirtyISOWeek);
      var diff = getISOWeek(date) - isoWeek;
      date.setDate(date.getDate() - diff * 7);
      return date;
    }

    module.exports = setISOWeek;
  }
});
//# sourceMappingURL=index.js.map