Liferay.Loader.define('segments-web$date-fns@1.30.1/locale/sv/build_format_locale/index', ['module', 'exports', 'require', '../../_lib/build_formatting_tokens_reg_exp/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var buildFormattingTokensRegExp = require('../../_lib/build_formatting_tokens_reg_exp/index');

    function buildFormatLocale() {
      var months3char = ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul', 'aug', 'sep', 'okt', 'nov', 'dec'];
      var monthsFull = ['januari', 'februari', 'mars', 'april', 'maj', 'juni', 'juli', 'augusti', 'september', 'oktober', 'november', 'december'];
      var weekdays2char = ['sö', 'må', 'ti', 'on', 'to', 'fr', 'lö'];
      var weekdays3char = ['sön', 'mån', 'tis', 'ons', 'tor', 'fre', 'lör'];
      var weekdaysFull = ['söndag', 'måndag', 'tisdag', 'onsdag', 'torsdag', 'fredag', 'lördag'];
      var meridiemFull = ['f.m.', 'e.m.'];

      var formatters = {
        // Month: Jan, Feb, ..., Dec
        'MMM': function (date) {
          return months3char[date.getMonth()];
        },

        // Month: January, February, ..., December
        'MMMM': function (date) {
          return monthsFull[date.getMonth()];
        },

        // Day of week: Su, Mo, ..., Sa
        'dd': function (date) {
          return weekdays2char[date.getDay()];
        },

        // Day of week: Sun, Mon, ..., Sat
        'ddd': function (date) {
          return weekdays3char[date.getDay()];
        },

        // Day of week: Sunday, Monday, ..., Saturday
        'dddd': function (date) {
          return weekdaysFull[date.getDay()];
        },

        // a.m., p.m.
        'aa': function (date) {
          return date.getHours() / 12 >= 1 ? meridiemFull[1] : meridiemFull[0];
        }
      };

      formatters.A = formatters.aa;
      formatters.a = formatters.aa;

      // Generate ordinal version of formatters: M -> Mo, D -> Do, etc.

      ['M', 'D', 'DDD', 'd', 'Q', 'W'].forEach(function (formatterToken) {
        formatters[formatterToken + 'o'] = function (date, formatters) {
          return ordinal(formatters[formatterToken](date));
        };
      });

      return {
        formatters: formatters,
        formattingTokensRegExp: buildFormattingTokensRegExp(formatters)
      };
    }

    function ordinal(number) {
      var rem100 = number % 100;
      if (rem100 > 20 || rem100 < 10) {
        switch (rem100 % 10) {
          case 1:
          case 2:
            return number + ':a';
        }
      }
      return number + ':e';
    }

    module.exports = buildFormatLocale;
  }
});
//# sourceMappingURL=index.js.map