Liferay.Loader.define('segments-web$date-fns@1.30.1/locale/pl/build_format_locale/index', ['module', 'exports', 'require', '../../_lib/build_formatting_tokens_reg_exp/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var buildFormattingTokensRegExp = require('../../_lib/build_formatting_tokens_reg_exp/index');

    function buildFormatLocale() {
      var months3char = ['sty', 'lut', 'mar', 'kwi', 'maj', 'cze', 'lip', 'sie', 'wrz', 'paź', 'lis', 'gru'];
      var monthsFull = ['styczeń', 'luty', 'marzec', 'kwiecień', 'maj', 'czerwiec', 'lipiec', 'sierpień', 'wrzesień', 'październik', 'listopad', 'grudzień'];
      var weekdays2char = ['nd', 'pn', 'wt', 'śr', 'cz', 'pt', 'sb'];
      var weekdays3char = ['niedz.', 'pon.', 'wt.', 'śr.', 'czw.', 'piąt.', 'sob.'];
      var weekdaysFull = ['niedziela', 'poniedziałek', 'wtorek', 'środa', 'czwartek', 'piątek', 'sobota'];
      var meridiem = ['w nocy', 'rano', 'po południu', 'wieczorem'];

      var formatters = {
        // Month: Jan, Feb, ..., Dec
        'MMM': function (date) {
          return months3char[date.getMonth()];
        },

        // Month: January, February, ..., December
        'MMMM': function (date) {
          return monthsFull[date.getMonth()];
        },

        // Day of week: Su, Mo, ..., Sa
        'dd': function (date) {
          return weekdays2char[date.getDay()];
        },

        // Day of week: Sun, Mon, ..., Sat
        'ddd': function (date) {
          return weekdays3char[date.getDay()];
        },

        // Day of week: Sunday, Monday, ..., Saturday
        'dddd': function (date) {
          return weekdaysFull[date.getDay()];
        },

        // Time of day
        'A': function (date) {
          var hours = date.getHours();
          if (hours >= 17) {
            return meridiem[3];
          } else if (hours >= 12) {
            return meridiem[2];
          } else if (hours >= 4) {
            return meridiem[1];
          } else {
            return meridiem[0];
          }
        }
      };

      formatters.a = formatters.A;
      formatters.aa = formatters.A;

      // Generate ordinal version of formatters: M -> Mo, D -> Do, etc.

      ['M', 'D', 'DDD', 'd', 'Q', 'W'].forEach(function (formatterToken) {
        formatters[formatterToken + 'o'] = function (date, formatters) {
          // Well, it should be just a number without any suffix
          return formatters[formatterToken](date).toString();
        };
      });

      return {
        formatters: formatters,
        formattingTokensRegExp: buildFormattingTokensRegExp(formatters)
      };
    }

    module.exports = buildFormatLocale;
  }
});
//# sourceMappingURL=index.js.map