Liferay.Loader.define('segments-web$date-fns@1.30.1/last_day_of_iso_week/index', ['module', 'exports', 'require', '../last_day_of_week/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var lastDayOfWeek = require('../last_day_of_week/index');

    /**
     * @category ISO Week Helpers
     * @summary Return the last day of an ISO week for the given date.
     *
     * @description
     * Return the last day of an ISO week for the given date.
     * The result will be in the local timezone.
     *
     * ISO week-numbering year: http://en.wikipedia.org/wiki/ISO_week_date
     *
     * @param {Date|String|Number} date - the original date
     * @returns {Date} the last day of an ISO week
     *
     * @example
     * // The last day of an ISO week for 2 September 2014 11:55:00:
     * var result = lastDayOfISOWeek(new Date(2014, 8, 2, 11, 55, 0))
     * //=> Sun Sep 07 2014 00:00:00
     */
    function lastDayOfISOWeek(dirtyDate) {
      return lastDayOfWeek(dirtyDate, { weekStartsOn: 1 });
    }

    module.exports = lastDayOfISOWeek;
  }
});
//# sourceMappingURL=index.js.map