Liferay.Loader.define('segments-web$date-fns@1.30.1/is_this_week/index', ['module', 'exports', 'require', '../is_same_week/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var isSameWeek = require('../is_same_week/index');

    /**
     * @category Week Helpers
     * @summary Is the given date in the same week as the current date?
     *
     * @description
     * Is the given date in the same week as the current date?
     *
     * @param {Date|String|Number} date - the date to check
     * @param {Object} [options] - the object with options
     * @param {Number} [options.weekStartsOn=0] - the index of the first day of the week (0 - Sunday)
     * @returns {Boolean} the date is in this week
     *
     * @example
     * // If today is 25 September 2014, is 21 September 2014 in this week?
     * var result = isThisWeek(new Date(2014, 8, 21))
     * //=> true
     *
     * @example
     * // If today is 25 September 2014 and week starts with Monday
     * // is 21 September 2014 in this week?
     * var result = isThisWeek(new Date(2014, 8, 21), {weekStartsOn: 1})
     * //=> false
     */
    function isThisWeek(dirtyDate, dirtyOptions) {
      return isSameWeek(new Date(), dirtyDate, dirtyOptions);
    }

    module.exports = isThisWeek;
  }
});
//# sourceMappingURL=index.js.map